/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class StreamUtils {
    private static final Gson GSON = new Gson();

    private StreamUtils() {
    }

    @Nullable
    public static <T> T fromJson(InputStream inputStream, Class<T> class_) {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            jsonReader.setLenient(false);
            return (T)GSON.getAdapter(class_).read(jsonReader);
        }
        catch (Exception exception) {
            throw new JsonParseException((Throwable)exception);
        }
    }

    @Nullable
    public static IDataPackObject fromPackObject(InputStream inputStream) {
        JsonObject object = StreamUtils.fromJson(inputStream, JsonObject.class);
        if (object != null) {
            return IDataPackObject.of((JsonElement)object);
        }
        return null;
    }

    @Nullable
    public static IDataPackObject fromPackObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        return StreamUtils.fromPackObject(new ByteArrayInputStream(jsonString.getBytes()));
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        return IOUtils.toString((InputStream)input, (Charset)encoding);
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

