/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;

public class OpenPoseStack
implements IPoseStack {
    private final OpenMatrix4f poseMatrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    private final OpenMatrix3f normalMatrix = OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f);

    @Override
    public void pushPose() {
    }

    @Override
    public void popPose() {
    }

    @Override
    public void translate(float x, float y, float z) {
        this.poseMatrix.multiply(OpenMatrix4f.createTranslateMatrix(x, y, z));
    }

    @Override
    public void scale(float x, float y, float z) {
        this.poseMatrix.multiply(OpenMatrix4f.createScaleMatrix(x, y, z));
        if (x == y && y == z) {
            if (x > 0.0f) {
                return;
            }
            this.normalMatrix.multiply(-1.0f);
        }
        float f = 1.0f / x;
        float f1 = 1.0f / y;
        float f2 = 1.0f / z;
        float f3 = MathUtils.fastInvCubeRoot(f * f1 * f2);
        this.normalMatrix.multiply(OpenMatrix3f.createScaleMatrix(f3 * f, f3 * f1, f3 * f2));
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        this.poseMatrix.rotate(quaternion);
        this.normalMatrix.rotate(quaternion);
    }

    @Override
    public void multiply(IMatrix3f matrix) {
        this.normalMatrix.multiply(OpenMatrix3f.of(matrix));
    }

    @Override
    public void multiply(IMatrix4f matrix) {
        this.poseMatrix.multiply(OpenMatrix4f.of(matrix));
    }

    @Override
    public OpenMatrix4f lastPose() {
        return this.poseMatrix;
    }

    @Override
    public OpenMatrix3f lastNormal() {
        return this.normalMatrix;
    }
}

