/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.ArrayList;
import java.util.Iterator;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.core.Position;
import net.minecraft.world.phys.AABB;

public class Rectangle3f
implements IRectangle3f {
    public static final Rectangle3f ZERO = new Rectangle3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private float x;
    private float y;
    private float z;
    private float width;
    private float height;
    private float depth;

    public Rectangle3f(Rectangle3i rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.z = rect.getZ();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
        this.depth = rect.getDepth();
    }

    public Rectangle3f(float x, float y, float z, float width, float height, float depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public Rectangle3f(AABB box) {
        this((float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_, (float)box.m_82362_(), (float)box.m_82376_(), (float)box.m_82385_());
    }

    @Override
    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public float getDepth() {
        return this.depth;
    }

    public void setDepth(float depth) {
        this.depth = depth;
    }

    @Override
    public float getMinX() {
        return this.x;
    }

    @Override
    public float getMinY() {
        return this.y;
    }

    @Override
    public float getMinZ() {
        return this.z;
    }

    @Override
    public float getMidX() {
        return this.x + this.width / 2.0f;
    }

    @Override
    public float getMidY() {
        return this.y + this.height / 2.0f;
    }

    @Override
    public float getMidZ() {
        return this.z + this.depth / 2.0f;
    }

    @Override
    public float getMaxX() {
        return this.x + this.width;
    }

    @Override
    public float getMaxY() {
        return this.y + this.height;
    }

    @Override
    public float getMaxZ() {
        return this.z + this.depth;
    }

    public Vector3f getCenter() {
        return new Vector3f(this.getMidX(), this.getMidY(), this.getMidZ());
    }

    public Vector3f getOrigin() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Rectangle3f getBounds() {
        return new Rectangle3f(-this.width / 2.0f, -this.height / 2.0f, -this.depth / 2.0f, this.width, this.height, this.depth);
    }

    public Rectangle3f copy() {
        return new Rectangle3f(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    public Rectangle3f scale(float s) {
        return new Rectangle3f(this.x * s, this.y * s, this.z * s, this.width * s, this.height * s, this.depth * s);
    }

    public Rectangle3f offset(Position point) {
        return this.offset((float)point.m_7096_(), (float)point.m_7098_(), (float)point.m_7094_());
    }

    public Rectangle3f offset(float dx, float dy, float dz) {
        return new Rectangle3f(this.x + dx, this.y + dy, this.z + dz, this.width, this.height, this.depth);
    }

    public Rectangle3f inflate(float value) {
        if (value == 0.0f) {
            return this;
        }
        float v2 = value + value;
        return new Rectangle3f(this.x - value, this.y - value, this.z - value, this.width + v2, this.height + v2, this.depth + v2);
    }

    public void mul(OpenQuaternionf quaternion) {
        this.mul(new OpenMatrix4f(quaternion));
    }

    public void mul(OpenMatrix4f matrix) {
        ArrayList<Vector4f> vertexes = ObjectUtils.map(new Vector4f(this.x, this.y, this.z, 1.0f), new Vector4f(this.x + this.width, this.y, this.z, 1.0f), new Vector4f(this.x + this.width, this.y + this.height, this.z, 1.0f), new Vector4f(this.x + this.width, this.y + this.height, this.z + this.depth, 1.0f), new Vector4f(this.x + this.width, this.y, this.z + this.depth, 1.0f), new Vector4f(this.x, this.y + this.height, this.z, 1.0f), new Vector4f(this.x, this.y + this.height, this.z + this.depth, 1.0f), new Vector4f(this.x, this.y, this.z + this.depth, 1.0f));
        Iterator iterator = vertexes.iterator();
        Vector4f point = (Vector4f)iterator.next();
        point.transform(matrix);
        float minX = point.x();
        float minY = point.y();
        float minZ = point.z();
        float maxX = point.x();
        float maxY = point.y();
        float maxZ = point.z();
        while (iterator.hasNext()) {
            point = (Vector4f)iterator.next();
            point.transform(matrix);
            minX = Math.min(minX, point.x());
            minY = Math.min(minY, point.y());
            minZ = Math.min(minZ, point.z());
            maxX = Math.max(maxX, point.x());
            maxY = Math.max(maxY, point.y());
            maxZ = Math.max(maxZ, point.z());
        }
        this.x = minX;
        this.y = minY;
        this.z = minZ;
        this.width = maxX - minX;
        this.height = maxY - minY;
        this.depth = maxZ - minZ;
    }

    public AABB asAABB() {
        return new AABB((double)this.x, (double)this.y, (double)this.z, (double)(this.x + this.width), (double)(this.y + this.height), (double)(this.z + this.depth));
    }

    public String toString() {
        return String.format("(%g %g %g; %g %g %g)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.depth));
    }
}

