/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.imbuement;

import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ISpellCasterProvider;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.items.ManipulationEssence;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record BulkScribingRecipe(ResourceLocation id) implements IImbuementRecipe
{
    public boolean isMatch(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.stack;
        List pedestalItems = imbuementTile.getPedestalItems();
        if (pedestalItems.size() != 1) {
            return false;
        }
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isEmpty()) {
            return false;
        }
        ItemStack scriberStack = scriber.get();
        ISpellCaster caster = CasterUtil.getCaster((ItemStack)scriberStack);
        if (caster == null || caster.getSpell().isEmpty()) {
            return false;
        }
        ISpellCaster reagentCaster = CasterUtil.getCaster((ItemStack)reagent);
        if (reagentCaster == null || !reagentCaster.getSpell().isEmpty()) {
            return false;
        }
        return reagent.m_41720_() instanceof IScribeable;
    }

    public Optional<ItemStack> findScriber(ImbuementTile imbuementTile) {
        return imbuementTile.getPedestalItems().stream().filter(this::isScriber).findFirst();
    }

    public boolean isScriber(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof SpellBook || item instanceof SpellParchment || item instanceof ManipulationEssence;
    }

    public ItemStack getResult(ImbuementTile imbuementTile) {
        Item item;
        ItemStack result = imbuementTile.stack.m_41777_();
        if (result.m_150930_((Item)ItemsRegistry.BLANK_PARCHMENT.get())) {
            result = new ItemStack((ItemLike)ItemsRegistry.SPELL_PARCHMENT.get());
        }
        if ((item = result.m_41720_()) instanceof IScribeable) {
            IScribeable scribeable = (IScribeable)item;
            item = imbuementTile.m_58904_();
            if (item instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)item;
                Optional<ItemStack> scriber = this.findScriber(imbuementTile);
                if (scriber.isPresent()) {
                    ItemStack is = scriber.get();
                    ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)serverLevel);
                    player.m_21008_(InteractionHand.MAIN_HAND, is);
                    scribeable.onScribe(imbuementTile.m_58904_(), imbuementTile.m_58899_(), (Player)player, InteractionHand.MAIN_HAND, result);
                }
            }
        }
        return result;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        Item item;
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isPresent() && (item = scriber.get().m_41720_()) instanceof ISpellCasterProvider) {
            ISpellCasterProvider provider = (ISpellCasterProvider)item;
            return provider.getSpellCaster(scriber.get()).getSpell().getCost();
        }
        return 1000;
    }

    public boolean matches(ImbuementTile container, Level level) {
        return false;
    }

    public ItemStack assemble(ImbuementTile container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AddonRecipeRegistry.BULK_SCRIBING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AddonRecipeRegistry.BULK_SCRIBING_TYPE.get();
    }

    public Component getCraftingStartedText(ImbuementTile imbuementTile) {
        return Component.m_237110_((String)"chat.ars_additions.imbued_spell_parchment.scribing_started", (Object[])new Object[]{this.getResult(imbuementTile).m_41786_()});
    }

    public Component getCraftingText(ImbuementTile imbuementTile) {
        Item item;
        ItemStack result = this.getResult(imbuementTile);
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isPresent() && (item = scriber.get().m_41720_()) instanceof ISpellCasterProvider) {
            ISpellCasterProvider provider = (ISpellCasterProvider)item;
            return Component.m_237110_((String)"tooltip.ars_additions.imbued_spell_parchment.scribing", (Object[])new Object[]{provider.getSpellCaster(scriber.get()).getSpell().getDisplayString()});
        }
        return Component.m_237110_((String)"tooltip.ars_additions.imbued_spell_parchment.scribing", (Object[])new Object[]{this.getResult(imbuementTile).m_41786_()});
    }

    public Component getCraftingProgressText(ImbuementTile imbuementTile, int progress) {
        return Component.m_237110_((String)"tooltip.ars_additions.imbued_spell_parchment.scribing_progress", (Object[])new Object[]{progress}).m_130940_(ChatFormatting.GOLD);
    }

    public JsonElement asRecipe() {
        JsonElement recipe = Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        JsonObject obj = recipe.getAsJsonObject();
        obj.addProperty("type", this.m_6671_().toString());
        return obj;
    }

    public static class Serializer
    implements RecipeSerializer<BulkScribingRecipe> {
        public static final Codec<BulkScribingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(BulkScribingRecipe::id)).apply((Applicative)instance, BulkScribingRecipe::new));

        public BulkScribingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(null);
        }

        @Nullable
        public BulkScribingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (BulkScribingRecipe)friendlyByteBuf.m_271872_(CODEC);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, BulkScribingRecipe recipe) {
            friendlyByteBuf.m_272073_(CODEC, (Object)recipe);
        }
    }
}

