/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.datagen.StructureTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateStructureProvider
extends SimpleDataProvider {
    public List<LocateStructureRecipe> recipes = new ArrayList<LocateStructureRecipe>();

    public LocateStructureProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (LocateStructureRecipe recipe : this.recipes) {
            Path path = LocateStructureProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        this.addEntry("pillager_outpost", (ResourceKey<Structure>)BuiltinStructures.f_209845_, ResourceOrTag.item(Items.f_42616_));
        this.addEntry("end_city", (ResourceKey<Structure>)BuiltinStructures.f_209861_, ResourceOrTag.item(Items.f_42004_));
        this.addEntry("jungle_temple", (ResourceKey<Structure>)BuiltinStructures.f_209849_, ResourceOrTag.item(Items.f_41998_));
        this.addEntry("wilden_den", (TagKey<Structure>)StructureTagProvider.WILDEN_DEN, ResourceOrTag.item((Item)ItemsRegistry.SOURCE_GEM.get()));
        this.addEntry("monument", (ResourceKey<Structure>)BuiltinStructures.f_209856_, ResourceOrTag.tag(ItemTags.f_13156_));
        this.addEntry("fortress", (ResourceKey<Structure>)BuiltinStructures.f_209859_, ResourceOrTag.item(Items.f_42691_));
        this.addEntry("ancient_city", (ResourceKey<Structure>)BuiltinStructures.f_226492_, ResourceOrTag.item(Items.f_151020_));
        this.addEntry("igloo", (ResourceKey<Structure>)BuiltinStructures.f_209851_, ResourceOrTag.item(Items.f_41980_));
        this.addEntry("bastion", (ResourceKey<Structure>)BuiltinStructures.f_209863_, ResourceOrTag.item(Items.f_42763_));
        this.addEntry("desert_temple", (ResourceKey<Structure>)BuiltinStructures.f_209850_, ResourceOrTag.item(Items.f_41856_));
        this.addEntry("trail_ruins", (ResourceKey<Structure>)BuiltinStructures.f_276588_, ResourceOrTag.tag(ItemTags.f_198161_));
        this.addEntry("arcane_library", (ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ArsAdditions.prefix("arcane_library")), ResourceOrTag.item((Item)ItemsRegistry.APPRENTICE_SPELLBOOK.get()));
    }

    private void addEntry(String id, ResourceKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.key(structureId), augments);
    }

    private void addEntry(String id, TagKey<Structure> structureId, ResourceOrTag<Item> ... augments) {
        this.addEntry(id, ResourceOrTag.tag(structureId), augments);
    }

    private void addEntry(String id, ResourceOrTag<Structure> structure, ResourceOrTag<Item> ... augments) {
        this.recipes.add(new LocateStructureRecipe(ArsAdditions.prefix(id), List.of(augments), structure, 50, true));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipes/locate_structure/" + id + ".json");
    }

    public String m_6055_() {
        return "Locate Structure Datagen";
    }
}

