/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.server.util.PlayerInvUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CharmRegistry {
    public static boolean isEnabled(CharmType type, LivingEntity entity) {
        return !CharmRegistry.getCharm(entity, type).m_41619_();
    }

    public static boolean isEnabled(CharmType type, ItemStack charm) {
        return charm.m_150930_((Item)AddonItemRegistry.CHARMS.get((Object)type).get()) && CharmRegistry.isEnabled(charm);
    }

    public static boolean isEnabled(ItemStack charm) {
        return CharmRegistry.getCharges(charm) > 0;
    }

    public static int getCharges(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return stack.m_41784_().m_128451_("charges");
    }

    public static void setCharges(ItemStack stack, int charges) {
        stack.m_41784_().m_128405_("charges", Math.max(charges, 0));
    }

    public static ItemStack getCharm(LivingEntity entity, CharmType charm) {
        return PlayerInvUtil.findItem(entity, stack -> CharmRegistry.isEnabled(charm, stack), ItemStack.f_41583_, Function.identity());
    }

    public static boolean processCharmEvent(LivingEntity entity, CharmType charm, Supplier<Boolean> predicate, BiFunction<LivingEntity, ItemStack, Integer> consumer) {
        Player player;
        if (!predicate.get().booleanValue()) {
            return false;
        }
        ItemStack curio = CharmRegistry.getCharm(entity, charm);
        if (curio == null || curio.m_41619_()) {
            return false;
        }
        int damage = consumer.apply(entity, curio);
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return true;
        }
        if (damage > 0) {
            CharmRegistry.setCharges(curio, CharmRegistry.getCharges(curio) - damage);
        }
        return true;
    }

    public static int every(int ticks, LivingEntity entity, int charges) {
        return entity.m_9236_().m_46467_() % (long)ticks == 0L ? charges : 0;
    }

    public static enum CharmType implements StringRepresentable
    {
        FIRE_RESISTANCE(1000, 5, "Emberward", "Nullifies Fire Damage", new ItemLike[]{Items.f_42542_, Items.f_42448_, Items.f_42409_}),
        UNDYING(1, 2000, "Second Wind", "Prevents you from dying", new ItemLike[]{Items.f_42747_, Items.f_42754_, Items.f_42054_}),
        DISPEL_PROTECTION(3, 1000, "Unyielding Magic", "Prevents you from being dispelled", new ItemLike[]{Items.f_42455_, Items.f_42740_, Items.f_42591_, Items.f_41951_}),
        FALL_PREVENTION(20, 20, "Featherlight", "Enables you to float down like a feather", new ItemLike[]{Items.f_42402_, Items.f_42714_}),
        WATER_BREATHING(1000, 5, "Ocean's Breath", "Enables you to breath underwater", new ItemLike[]{Items.f_42529_, Items.f_42532_, Items.f_41910_}),
        ENDER_MASK(100, 10, "Ender Serenity", "Masks you from an Enderman's anger", new ItemLike[]{Items.f_42046_, Items.f_42730_}),
        VOID_PROTECTION(1, 2000, "Void's Salvation", "Saves you from the void", new ItemLike[]{ItemsRegistry.STABLE_WARP_SCROLL, Items.f_42103_}),
        SONIC_BOOM_PROTECTION(3, 1000, "Resonant Shield", "Protects you from the Warden's Sonic Boom", new ItemLike[]{Items.f_220192_, Items.f_42740_, Items.f_41870_}),
        WITHER_PROTECTION(10, 100, "Decay's End", "Prevents you from being afflicted with Wither", new ItemLike[]{Items.f_41951_, Items.f_42679_, Items.f_42455_}),
        GOLDEN(1000, 5, "Gilded Friendship", "Makes Piglins neutral to the wearer", new ItemLike[]{Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42758_}),
        NIGHT_VISION(20, 10, "Darkvision", "Enables the wearer to see in low-light environments", new ItemLike[]{Items.f_42778_, Items.f_42000_}),
        POWDERED_SNOW_WALK(1000, 5, "Snowstride", "Enables the wearer to walk on powdered snow", new ItemLike[]{Items.f_42463_, Items.f_151055_});

        private final int charges;
        private final int costPerCharge;
        private final String name;
        private final String desc;
        private final ArrayList<ItemLike> pedestalItems = new ArrayList();

        private CharmType(int charges, int costPerCharge, String name, String desc, ItemLike ... items) {
            this.charges = charges;
            this.costPerCharge = costPerCharge;
            this.name = name;
            this.desc = desc;
            this.pedestalItems.addAll(List.of(items));
        }

        public int getCharges() {
            return this.charges;
        }

        public int getCostPerCharge() {
            return this.costPerCharge;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public ArrayList<ItemLike> getPedestalItems() {
            return this.pedestalItems;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH) + "_charm";
        }
    }
}

