/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.ars_botania.mixin;

import com.google.common.collect.Iterables;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import studio.fantasyit.ars_botania.ArsBotania;
import studio.fantasyit.ars_botania.Config;
import studio.fantasyit.ars_botania.api.IArsManaCap;
import studio.fantasyit.ars_botania.data.ConvertEnums;
import studio.fantasyit.ars_botania.utils.DoubleAccumulator;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(value={ManaCap.class}, remap=false)
public abstract class ArsManaCap
implements IArsManaCap {
    @Nullable
    public DoubleAccumulator accumulator;
    @Nullable
    public DoubleAccumulator storeAccumulator;
    @Unique
    Player ars_botania$player;
    @Shadow
    private int maxMana;
    @Shadow
    private double mana;
    @Unique
    private double t_mana = 0.0;

    public DoubleAccumulator getAccumulator() {
        if (this.accumulator == null) {
            this.accumulator = new DoubleAccumulator(ConvertEnums.getWhenPlayerCoseBotaniaManaAndWillBeConvertedToPlayerSource());
        }
        return this.accumulator;
    }

    public DoubleAccumulator getStoreAccumulator() {
        if (this.storeAccumulator == null) {
            this.storeAccumulator = new DoubleAccumulator(ConvertEnums.getWhenPlayerUsePlayerSourceToFillInMana());
        }
        return this.storeAccumulator;
    }

    @Override
    public void setPlayer(Player player) {
        this.ars_botania$player = player;
    }

    @Override
    public Player getPlayer() {
        return this.ars_botania$player;
    }

    @Shadow
    public abstract double setMana(double var1);

    @Override
    public double ars_botania$getRawMana() {
        return this.mana;
    }

    @Override
    public int ars_botania$getRawMaxMana() {
        return this.maxMana;
    }

    @Inject(at={@At(value="RETURN")}, method={"getCurrentMana"}, cancellable=true)
    public void ars_botania$getMana(CallbackInfoReturnable<Double> cir) {
        if (!Config.playerManaConvertEnable) {
            return;
        }
        if (this.ars_botania$player == null) {
            return;
        }
        ManaItemHandler inst = ManaItemHandler.instance();
        List items = inst.getManaItems(this.ars_botania$player);
        List acc = inst.getManaAccesories(this.ars_botania$player);
        double manaReceived = 0.0;
        for (ItemStack stackInSlot : Iterables.concat((Iterable)items, (Iterable)acc)) {
            ManaItem manaItem;
            if (stackInSlot.m_150930_((Item)ArsBotania.FAKE_MANA_ITEM.get()) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)) == null || !manaItem.canExportManaToItem(this.ars_botania$player.m_21205_()) || manaItem.getMana() <= 0) continue;
            manaReceived += (double)manaItem.getMana();
        }
        cir.setReturnValue((Object)((Double)cir.getReturnValue() + this.getAccumulator().inner2outer(manaReceived)));
    }

    @Inject(at={@At(value="RETURN")}, method={"getMaxMana"}, cancellable=true)
    public void ars_botania$getMaxMana(CallbackInfoReturnable<Integer> cir) {
        if (!Config.playerManaConvertEnable) {
            return;
        }
        if (this.ars_botania$player == null) {
            return;
        }
        ManaItemHandler inst = ManaItemHandler.instance();
        List items = inst.getManaItems(this.ars_botania$player);
        List acc = inst.getManaAccesories(this.ars_botania$player);
        int manaReceived = 0;
        for (ItemStack stackInSlot : Iterables.concat((Iterable)items, (Iterable)acc)) {
            ManaItem manaItem;
            if (stackInSlot.m_150930_((Item)ArsBotania.FAKE_MANA_ITEM.get()) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)) == null || !manaItem.canExportManaToItem(this.ars_botania$player.m_21205_()) || manaItem.getMana() <= 0) continue;
            manaReceived += manaItem.getMaxMana();
        }
        cir.setReturnValue((Object)((Integer)cir.getReturnValue() + this.getAccumulator().inner2outer(manaReceived)));
    }

    @ModifyVariable(method={"addMana"}, at=@At(value="HEAD"), argsOnly=true)
    public double ars_botania$addMana(double manaToAdd) {
        if (!Config.playerManaConvertEnable) {
            return manaToAdd;
        }
        if (this.ars_botania$player == null) {
            return manaToAdd;
        }
        this.t_mana = this.mana;
        if (manaToAdd > (double)this.maxMana - this.mana) {
            if (Config.playerManaRecoveryChargeItem) {
                double extraMana = manaToAdd - ((double)this.maxMana - this.mana);
                int realMana = this.getStoreAccumulator().accumulateAndGet((int)extraMana);
                ManaItemHandler.instance().dispatchMana(((Item)ArsBotania.FAKE_MANA_ITEM.get()).m_7968_(), this.ars_botania$player, realMana, true);
            }
            return (double)this.maxMana - this.mana;
        }
        return manaToAdd;
    }

    @ModifyVariable(method={"removeMana"}, at=@At(value="HEAD"), argsOnly=true)
    public double ars_botania$removeMana(double manaToRemove) {
        if (!Config.playerManaConvertEnable) {
            return manaToRemove;
        }
        if (this.ars_botania$player == null) {
            return manaToRemove;
        }
        this.t_mana = this.mana;
        if (manaToRemove > this.mana) {
            double extraMana = manaToRemove - this.mana;
            int realMana = this.getAccumulator().takeAndGetCost(extraMana);
            ManaItemHandler.instance().requestMana(((Item)ArsBotania.FAKE_MANA_ITEM.get()).m_7968_(), this.ars_botania$player, realMana, true);
            return this.mana;
        }
        return manaToRemove;
    }

    @Inject(method={"addMana"}, at={@At(value="RETURN")})
    public void ars_botania$addMana_setMana(double manaToAdd, CallbackInfoReturnable<Double> cir) {
        if (!Config.playerManaConvertEnable) {
            return;
        }
        this.setMana(this.t_mana + manaToAdd);
    }

    @Inject(method={"removeMana"}, at={@At(value="RETURN")})
    public void ars_botania$removeMana_setMana(double manaToRemove, CallbackInfoReturnable<Double> cir) {
        if (!Config.playerManaConvertEnable) {
            return;
        }
        this.setMana(this.t_mana - manaToRemove);
    }

    @Inject(at={@At(value="RETURN")}, method={"serializeNBT*"}, cancellable=true)
    public void serializeNBT(CallbackInfoReturnable<CompoundTag> tagRet) {
        if (!Config.playerManaConvertEnable) {
            return;
        }
        CompoundTag returnValue = (CompoundTag)tagRet.getReturnValue();
        returnValue.m_128405_("max", this.maxMana);
        returnValue.m_128347_("current", this.mana);
        tagRet.setReturnValue((Object)returnValue);
    }
}

