/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.DiveAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.FlyHelper;
import com.hollingsworth.arsnouveau.common.entity.goal.stalker.StartFlightGoal;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenStalker
extends Monster
implements GeoEntity {
    int leapCooldown;
    public Vec3 orbitOffset = Vec3.f_82478_;
    public BlockPos orbitPosition = BlockPos.f_121853_;
    public static final EntityDataAccessor<Boolean> isFlying = SynchedEntityData.m_135353_(WildenStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int timeFlying;
    AnimationController<WildenStalker> flyController;
    AnimationController<WildenStalker> groundController;
    AnimationController<WildenStalker> idleController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WildenStalker(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyHelper(this);
    }

    public WildenStalker(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_STALKER.get()), worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new StartFlightGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DiveAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.STALKER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.isFlying() && this.m_20096_()) {
                this.setFlying(false);
            }
            this.timeFlying = this.isFlying() ? ++this.timeFlying : 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && entityIn instanceof LivingEntity && this.f_19853_.m_46791_() == Difficulty.HARD) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0));
        }
        return super.m_7327_(entityIn);
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public int getLeapCooldown() {
        return this.leapCooldown;
    }

    public void setLeapCooldown(int leapCooldown) {
        this.leapCooldown = leapCooldown;
    }

    public int m_213860_() {
        return 8;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    private PlayState flyPredicate(AnimationState event) {
        if (this.isFlying()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState groundPredicate(AnimationState e) {
        if (this.isFlying()) {
            return PlayState.STOP;
        }
        if (e.isMoving()) {
            e.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        this.flyController = new AnimationController((GeoAnimatable)this, "flyController", 1, this::flyPredicate);
        animatableManager.add(new AnimationController[]{this.flyController});
        this.groundController = new AnimationController((GeoAnimatable)this, "groundController", 1, this::groundPredicate);
        animatableManager.add(new AnimationController[]{this.groundController});
        this.idleController = new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate);
        animatableManager.add(new AnimationController[]{this.idleController});
    }

    private <T extends GeoAnimatable> PlayState idlePredicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving() || this.isFlying()) {
            return PlayState.STOP;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.m_7840_(y, onGroundIn, state, pos);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.isFlying()) {
            super.m_7023_(travelVector);
            return;
        }
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_267651_(false);
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.7).m_22268_(Attributes.f_22281_, 2.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(isFlying, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(isFlying);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(isFlying, (Object)flying);
    }

    public void m_20258_(CompoundTag pCompound) {
        super.m_20258_(pCompound);
        this.setFlying(pCompound.m_128471_("isFlying"));
    }

    public boolean m_20223_(CompoundTag pCompound) {
        pCompound.m_128379_("isFlying", this.isFlying());
        return super.m_20223_(pCompound);
    }

    public static enum Animations {
        ATTACK,
        DIVE,
        FLY;

    }
}

