/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class StarbyListBehavior
extends StarbyBehavior {
    public List<BlockPos> FROM_LIST = new ArrayList<BlockPos>();
    public List<BlockPos> TO_LIST = new ArrayList<BlockPos>();
    public Map<Integer, Direction> FROM_DIRECTION_MAP = new HashMap<Integer, Direction>();
    public Map<Integer, Direction> TO_DIRECTION_MAP = new HashMap<Integer, Direction>();

    public StarbyListBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        BlockPos pos;
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.FROM_LIST.contains(pos)) {
                this.FROM_LIST.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.TO_LIST.contains(pos)) {
                this.TO_LIST.add(pos);
            }
            ++counter;
        }
        for (String key : tag.m_128431_()) {
            int hash;
            if (key.startsWith("from_direction_")) {
                hash = Integer.parseInt(key.substring(15));
                this.FROM_DIRECTION_MAP.put(hash, Direction.m_122376_((int)tag.m_128451_(key)));
            }
            if (!key.startsWith("to_direction_")) continue;
            hash = Integer.parseInt(key.substring(13));
            this.TO_DIRECTION_MAP.put(hash, Direction.m_122376_((int)tag.m_128451_(key)));
        }
    }

    @Override
    public boolean clearOrRemove() {
        return this.FROM_LIST.isEmpty() && this.TO_LIST.isEmpty();
    }

    @Override
    public void onWanded(Player playerEntity) {
        super.onWanded(playerEntity);
        this.FROM_LIST = new ArrayList<BlockPos>();
        this.TO_LIST = new ArrayList<BlockPos>();
        this.FROM_DIRECTION_MAP = new HashMap<Integer, Direction>();
        this.TO_DIRECTION_MAP = new HashMap<Integer, Direction>();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.cleared"));
        this.syncTag();
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        for (BlockPos toPos : this.TO_LIST) {
            list.add(ColorPos.centered(toPos, ParticleColor.TO_HIGHLIGHT));
        }
        for (BlockPos fromPos : this.FROM_LIST) {
            list.add(ColorPos.centered(fromPos, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    public void addFromPos(BlockPos fromPos) {
        if (!this.FROM_LIST.contains(fromPos)) {
            this.FROM_LIST.add(fromPos.m_7949_());
            this.syncTag();
        }
    }

    public void addToPos(BlockPos toPos) {
        if (!this.TO_LIST.contains(toPos)) {
            this.TO_LIST.add(toPos.m_7949_());
            this.syncTag();
        }
    }

    public void addFromPos(BlockPos fromPos, Direction direction) {
        if (!this.FROM_LIST.contains(fromPos) || this.FROM_DIRECTION_MAP.get(fromPos.hashCode()) != direction) {
            this.FROM_LIST.add(fromPos.m_7949_());
            this.FROM_DIRECTION_MAP.put(fromPos.hashCode(), direction);
            this.syncTag();
        }
    }

    public void addToPos(BlockPos toPos, Direction direction) {
        if (!this.TO_LIST.contains(toPos) || this.TO_DIRECTION_MAP.get(toPos.hashCode()) != direction) {
            this.TO_LIST.add(toPos.m_7949_());
            this.TO_DIRECTION_MAP.put(toPos.hashCode(), direction);
            this.syncTag();
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        int counter = 0;
        for (BlockPos blockPos : this.FROM_LIST) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, blockPos);
            ++counter;
        }
        counter = 0;
        for (BlockPos blockPos : this.TO_LIST) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, blockPos);
            ++counter;
        }
        for (Map.Entry entry : this.FROM_DIRECTION_MAP.entrySet()) {
            if (entry.getValue() == null) continue;
            tag.m_128405_("from_direction_" + entry.getKey(), ((Direction)entry.getValue()).ordinal());
        }
        for (Map.Entry entry : this.TO_DIRECTION_MAP.entrySet()) {
            if (entry.getValue() == null) continue;
            tag.m_128405_("to_direction_" + entry.getKey(), ((Direction)entry.getValue()).ordinal());
        }
        return super.toTag(tag);
    }

    @Override
    protected ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", "starby_list");
    }
}

