/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.AlchemistsCrown;
import com.hollingsworth.arsnouveau.common.items.AnnotatedCodex;
import com.hollingsworth.arsnouveau.common.items.BlankParchmentItem;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.items.Debug;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.DowsingRod;
import com.hollingsworth.arsnouveau.common.items.EarthEssence;
import com.hollingsworth.arsnouveau.common.items.EnchantersMirror;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.items.EnchantersSword;
import com.hollingsworth.arsnouveau.common.items.ExperienceGem;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.FireEssence;
import com.hollingsworth.arsnouveau.common.items.FlaskCannon;
import com.hollingsworth.arsnouveau.common.items.FormSpellArrow;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.JarOfLight;
import com.hollingsworth.arsnouveau.common.items.ManipulationEssence;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.items.Present;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.ScryCaster;
import com.hollingsworth.arsnouveau.common.items.ScryerScroll;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.hollingsworth.arsnouveau.common.items.SpellCrossbow;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.StarbuncleShades;
import com.hollingsworth.arsnouveau.common.items.StarbuncleShard;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.items.Wand;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.items.WixieHat;
import com.hollingsworth.arsnouveau.common.items.WornNotebook;
import com.hollingsworth.arsnouveau.common.items.curios.AbstractManaCurio;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfLevitation;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfUnstableGifts;
import com.hollingsworth.arsnouveau.common.items.curios.DiscountRing;
import com.hollingsworth.arsnouveau.common.items.curios.JumpingRing;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.items.curios.SummoningFocus;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.AllowItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.DenyItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.MimicItemScroll;
import com.hollingsworth.arsnouveau.common.items.summon_charms.AmethystGolemCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.BookwyrmCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.DrygmyCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.StarbuncleCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WhirlisprigCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WixieCharm;
import com.hollingsworth.arsnouveau.common.perk.EmptyPerk;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class ItemsRegistry {
    public static PerkItem BLANK_THREAD;
    public static FoodProperties SOURCE_BERRY_FOOD;
    public static FoodProperties SOURCE_PIE_FOOD;
    public static FoodProperties SOURCE_ROLL_FOOD;
    public static FoodProperties MENDOSTEEN_FOOD;
    public static FoodProperties BLASTING_FOOD;
    public static FoodProperties BASTION_FOOD;
    public static FoodProperties FROSTAYA_FOOD;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryWrapper<RunicChalk> RUNIC_CHALK;
    public static final RegistryWrapper<SpellBook> NOVICE_SPELLBOOK;
    public static final RegistryWrapper<SpellBook> APPRENTICE_SPELLBOOK;
    public static final RegistryWrapper<SpellBook> ARCHMAGE_SPELLBOOK;
    public static final RegistryWrapper<SpellBook> CREATIVE_SPELLBOOK;
    public static final RegistryWrapper<ModItem> BLANK_GLYPH;
    public static final RegistryWrapper<ModItem> MAGE_BLOOM;
    public static final RegistryWrapper<ModItem> MAGE_FIBER;
    public static final RegistryWrapper<ModItem> MUNDANE_BELT;
    public static final RegistryWrapper<JarOfLight> JAR_OF_LIGHT;
    public static final RegistryWrapper<BeltOfLevitation> BELT_OF_LEVITATION;
    public static final RegistryWrapper<WornNotebook> WORN_NOTEBOOK;
    public static final RegistryWrapper<ModItem> RING_OF_POTENTIAL;
    public static final RegistryWrapper<DiscountRing> RING_OF_LESSER_DISCOUNT;
    public static final RegistryWrapper<DiscountRing> RING_OF_GREATER_DISCOUNT;
    public static final RegistryWrapper<BeltOfUnstableGifts> BELT_OF_UNSTABLE_GIFTS;
    public static final RegistryWrapper<WarpScroll> WARP_SCROLL;
    public static final RegistryWrapper<SpellParchment> SPELL_PARCHMENT;
    public static final RegistryWrapper<BookwyrmCharm> BOOKWYRM_CHARM;
    public static final RegistryWrapper<DominionWand> DOMINION_ROD;
    public static final RegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_BOOST;
    public static final RegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_REGEN;
    public static final RegistryWrapper<ModItem> DULL_TRINKET;
    public static final RegistryWrapper<StarbuncleCharm> STARBUNCLE_CHARM;
    public static final RegistryWrapper<Debug> debug;
    public static final RegistryWrapper<StarbuncleShard> STARBUNCLE_SHARD;
    public static final RegistryWrapper<StarbuncleShades> STARBUNCLE_SHADES;
    public static final RegistryWrapper<WhirlisprigCharm> WHIRLISPRIG_CHARM;
    public static final RegistryWrapper<ModItem> WHIRLISPRIG_SHARDS;
    public static final RegistryWrapper<ModItem> SOURCE_GEM;
    public static final RegistryWrapper<AllowItemScroll> ALLOW_ITEM_SCROLL;
    public static final RegistryWrapper<DenyItemScroll> DENY_ITEM_SCROLL;
    public static final RegistryWrapper<MimicItemScroll> MIMIC_ITEM_SCROLL;
    public static final RegistryWrapper<BlankParchmentItem> BLANK_PARCHMENT;
    public static final RegistryWrapper<Wand> WAND;
    public static final RegistryWrapper<VoidJar> VOID_JAR;
    public static final RegistryWrapper<WixieCharm> WIXIE_CHARM;
    public static final RegistryWrapper<ModItem> WIXIE_SHARD;
    public static final RegistryWrapper<SpellBow> SPELL_BOW;
    public static final RegistryWrapper<SpellArrow> AMPLIFY_ARROW;
    public static final RegistryWrapper<FormSpellArrow> SPLIT_ARROW;
    public static final RegistryWrapper<FormSpellArrow> PIERCE_ARROW;
    public static final RegistryWrapper<ModItem> WILDEN_HORN;
    public static final RegistryWrapper<ModItem> WILDEN_SPIKE;
    public static final RegistryWrapper<ModItem> WILDEN_WING;
    public static final RegistryWrapper<PotionFlask> POTION_FLASK;
    public static RegistryWrapper<PotionFlask> POTION_FLASK_AMPLIFY;
    public static RegistryWrapper<PotionFlask> POTION_FLASK_EXTEND_TIME;
    public static RegistryWrapper<ExperienceGem> EXPERIENCE_GEM;
    public static RegistryWrapper<ExperienceGem> GREATER_EXPERIENCE_GEM;
    public static final RegistryWrapper<EnchantersSword> ENCHANTERS_SWORD;
    public static final RegistryWrapper<EnchantersShield> ENCHANTERS_SHIELD;
    public static final RegistryWrapper<CasterTome> CASTER_TOME;
    public static final RegistryWrapper<DrygmyCharm> DRYGMY_CHARM;
    public static final RegistryWrapper<ModItem> DRYGMY_SHARD;
    public static final RegistryWrapper<ModItem> WILDEN_TRIBUTE;
    public static final RegistryWrapper<SummoningFocus> SUMMONING_FOCUS;
    public static final RegistryWrapper<ShapersFocus> SHAPERS_FOCUS;
    public static final RegistryWrapper<ModItem> SOURCE_BERRY_PIE;
    public static final RegistryWrapper<ModItem> SOURCE_BERRY_ROLL;
    public static final RegistryWrapper<EnchantersMirror> ENCHANTERS_MIRROR;
    public static final RegistryWrapper<AnimatedMagicArmor> SORCERER_BOOTS;
    public static final RegistryWrapper<AnimatedMagicArmor> SORCERER_LEGGINGS;
    public static final RegistryWrapper<AnimatedMagicArmor> SORCERER_ROBES;
    public static final RegistryWrapper<AnimatedMagicArmor> SORCERER_HOOD;
    public static final RegistryWrapper<AnimatedMagicArmor> ARCANIST_BOOTS;
    public static final RegistryWrapper<AnimatedMagicArmor> ARCANIST_LEGGINGS;
    public static final RegistryWrapper<AnimatedMagicArmor> ARCANIST_ROBES;
    public static final RegistryWrapper<AnimatedMagicArmor> ARCANIST_HOOD;
    public static final RegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_BOOTS;
    public static final RegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_LEGGINGS;
    public static final RegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_ROBES;
    public static final RegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_HOOD;
    public static final RegistryWrapper<DowsingRod> DOWSING_ROD;
    public static final RegistryWrapper<ModItem> ABJURATION_ESSENCE;
    public static final RegistryWrapper<ModItem> CONJURATION_ESSENCE;
    public static final RegistryWrapper<ModItem> AIR_ESSENCE;
    public static final RegistryWrapper<EarthEssence> EARTH_ESSENCE;
    public static final RegistryWrapper<FireEssence> FIRE_ESSENCE;
    public static final RegistryWrapper<ManipulationEssence> MANIPULATION_ESSENCE;
    public static final RegistryWrapper<ModItem> WATER_ESSENCE;
    public static final RegistryWrapper<AmethystGolemCharm> AMETHYST_GOLEM_CHARM;
    public static final RegistryWrapper<AnnotatedCodex> ANNOTATED_CODEX;
    public static final RegistryWrapper<ScryerScroll> SCRYER_SCROLL;
    public static final RegistryWrapper<ModItem> WIXIE_HAT;
    public static final RegistryWrapper<ModItem> ALCHEMISTS_CROWN;
    public static final RegistryWrapper<ModItem> SPLASH_LAUNCHER;
    public static final RegistryWrapper<ModItem> LINGERING_LAUNCHER;
    public static final RegistryWrapper<RecordItem> FIREL_DISC;
    public static final RegistryWrapper<RecordItem> SOUND_OF_GLASS;
    public static final RegistryWrapper<RecordItem> WILD_HUNT;
    public static final RegistryWrapper<Present> STARBY_GIFY;
    public static final RegistryWrapper<SpellCrossbow> SPELL_CROSSBOW;
    public static final RegistryWrapper<StableWarpScroll> STABLE_WARP_SCROLL;
    public static final RegistryWrapper<ScryCaster> SCRY_CASTER;
    public static final RegistryWrapper<JumpingRing> JUMP_RING;

    public static <T extends Item> RegistryWrapper<T> register(String name, Supplier<T> item) {
        return new RegistryWrapper(ITEMS.register(name, item));
    }

    public static RegistryWrapper<ModItem> register(String name) {
        return ItemsRegistry.register(name, ModItem::new);
    }

    public static void onItemRegistry(IForgeRegistry<Item> registry) {
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        for (Map.Entry<ResourceLocation, Supplier<Glyph>> glyphEntry : GlyphRegistry.getGlyphItemMap().entrySet()) {
            Glyph glyph = glyphEntry.getValue().get();
            registry.register(glyphEntry.getKey(), (Object)glyph);
            glyph.spellPart.glyphItem = glyph;
        }
        for (AbstractRitual ritual : RitualRegistry.getRitualMap().values()) {
            RitualTablet tablet = new RitualTablet(ritual);
            registry.register(ritual.getRegistryName(), (Object)tablet);
            RitualRegistry.getRitualItemMap().put(ritual.getRegistryName(), tablet);
        }
        for (AbstractFamiliarHolder holder : FamiliarRegistry.getFamiliarHolderMap().values()) {
            FamiliarScript script = new FamiliarScript(holder);
            FamiliarRegistry.getFamiliarScriptMap().put(holder.getRegistryName(), script);
            registry.register(holder.getRegistryName(), (Object)script);
        }
        for (IPerk perk : PerkRegistry.getPerkMap().values()) {
            PerkItem perkItem = new PerkItem(perk);
            PerkRegistry.getPerkItemMap().put(perk.getRegistryName(), perkItem);
            registry.register(perk.getRegistryName(), (Object)perkItem);
            if (!(perk instanceof EmptyPerk)) continue;
            BLANK_THREAD = perkItem;
        }
        ITEMS.register("drygmy_se", () -> new ForgeSpawnEggItem(ModEntities.ENTITY_DRYGMY, 10051392, 16770611, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("starbuncle_se", () -> new ForgeSpawnEggItem(ModEntities.STARBUNCLE_TYPE, 16757299, 16770611, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("whirlisprig_se", () -> new ForgeSpawnEggItem(ModEntities.WHIRLISPRIG_TYPE, 0x77FF33, 0xFFFB00, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_hunter_se", () -> new ForgeSpawnEggItem(ModEntities.WILDEN_HUNTER, 0xFDFDFD, 13281663, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_guardian_se", () -> new ForgeSpawnEggItem(ModEntities.WILDEN_GUARDIAN, 0xFFFFFF, 16752128, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_stalker_se", () -> new ForgeSpawnEggItem(ModEntities.WILDEN_STALKER, 10183948, 15669272, ItemsRegistry.defaultItemProperties()));
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties();
    }

    static {
        SOURCE_BERRY_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 100), 1.0f).m_38765_().m_38767_();
        SOURCE_PIE_FOOD = new FoodProperties.Builder().m_38760_(9).m_38758_(0.9f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 1200, 1), 1.0f).m_38765_().m_38767_();
        SOURCE_ROLL_FOOD = new FoodProperties.Builder().m_38760_(8).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
        MENDOSTEEN_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.RECOVERY_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
        BLASTING_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.BLAST_EFFECT.get(), 200), 1.0f).m_38765_().m_38767_();
        BASTION_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.DEFENCE_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
        FROSTAYA_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.FREEZING_EFFECT.get(), 600), 1.0f).m_38765_().m_38767_();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_nouveau");
        RUNIC_CHALK = ItemsRegistry.register("runic_chalk", RunicChalk::new);
        NOVICE_SPELLBOOK = ItemsRegistry.register("novice_spell_book", () -> new SpellBook(SpellTier.ONE));
        APPRENTICE_SPELLBOOK = ItemsRegistry.register("apprentice_spell_book", () -> new SpellBook(SpellTier.TWO));
        ARCHMAGE_SPELLBOOK = ItemsRegistry.register("archmage_spell_book", () -> new SpellBook(SpellTier.THREE));
        CREATIVE_SPELLBOOK = ItemsRegistry.register("creative_spell_book", () -> new SpellBook(SpellTier.CREATIVE));
        BLANK_GLYPH = ItemsRegistry.register("blank_glyph");
        MAGE_BLOOM = ItemsRegistry.register("magebloom", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.magebloom")));
        MAGE_FIBER = ItemsRegistry.register("magebloom_fiber");
        MUNDANE_BELT = ItemsRegistry.register("mundane_belt", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
        JAR_OF_LIGHT = ItemsRegistry.register("jar_of_light", JarOfLight::new);
        BELT_OF_LEVITATION = ItemsRegistry.register("belt_of_levitation", BeltOfLevitation::new);
        WORN_NOTEBOOK = ItemsRegistry.register("worn_notebook", WornNotebook::new);
        RING_OF_POTENTIAL = ItemsRegistry.register("ring_of_potential", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
        RING_OF_LESSER_DISCOUNT = ItemsRegistry.register("ring_of_lesser_discount", () -> new DiscountRing(){

            @Override
            public int getManaDiscount() {
                return 10;
            }
        });
        RING_OF_GREATER_DISCOUNT = ItemsRegistry.register("ring_of_greater_discount", () -> new DiscountRing(){

            @Override
            public int getManaDiscount() {
                return 20;
            }
        });
        BELT_OF_UNSTABLE_GIFTS = ItemsRegistry.register("belt_of_unstable_gifts", BeltOfUnstableGifts::new);
        WARP_SCROLL = ItemsRegistry.register("warp_scroll", WarpScroll::new);
        SPELL_PARCHMENT = ItemsRegistry.register("spell_parchment", SpellParchment::new);
        BOOKWYRM_CHARM = ItemsRegistry.register("bookwyrm_charm", BookwyrmCharm::new);
        DOMINION_ROD = ItemsRegistry.register("dominion_wand", DominionWand::new);
        AMULET_OF_MANA_BOOST = ItemsRegistry.register("amulet_of_mana_boost", () -> new AbstractManaCurio(){

            @Override
            public int getMaxManaBoost(ItemStack i) {
                return 50;
            }
        });
        AMULET_OF_MANA_REGEN = ItemsRegistry.register("amulet_of_mana_regen", () -> new AbstractManaCurio(){

            @Override
            public int getManaRegenBonus(ItemStack i) {
                return 3;
            }
        });
        DULL_TRINKET = ItemsRegistry.register("dull_trinket", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
        STARBUNCLE_CHARM = ItemsRegistry.register("starbuncle_charm", StarbuncleCharm::new);
        debug = ItemsRegistry.register("debug", Debug::new);
        STARBUNCLE_SHARD = ItemsRegistry.register("starbuncle_shards", StarbuncleShard::new);
        STARBUNCLE_SHADES = ItemsRegistry.register("starbuncle_shades", StarbuncleShades::new);
        WHIRLISPRIG_CHARM = ItemsRegistry.register("whirlisprig_charm", WhirlisprigCharm::new);
        WHIRLISPRIG_SHARDS = ItemsRegistry.register("whirlisprig_shards", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.whirlisprig_shard")));
        SOURCE_GEM = ItemsRegistry.register("source_gem", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.source_gem")));
        ALLOW_ITEM_SCROLL = ItemsRegistry.register("allow_scroll", AllowItemScroll::new);
        DENY_ITEM_SCROLL = ItemsRegistry.register("deny_scroll", DenyItemScroll::new);
        MIMIC_ITEM_SCROLL = ItemsRegistry.register("mimic_scroll", MimicItemScroll::new);
        BLANK_PARCHMENT = ItemsRegistry.register("blank_parchment", BlankParchmentItem::new);
        WAND = ItemsRegistry.register("wand", Wand::new);
        VOID_JAR = ItemsRegistry.register("void_jar", VoidJar::new);
        WIXIE_CHARM = ItemsRegistry.register("wixie_charm", WixieCharm::new);
        WIXIE_SHARD = ItemsRegistry.register("wixie_shards", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wixie_shard")));
        SPELL_BOW = ItemsRegistry.register("spell_bow", SpellBow::new);
        AMPLIFY_ARROW = ItemsRegistry.register("amplify_arrow", () -> new SpellArrow(AugmentAmplify.INSTANCE, 2));
        SPLIT_ARROW = ItemsRegistry.register("split_arrow", () -> new FormSpellArrow(AugmentSplit.INSTANCE, 2));
        PIERCE_ARROW = ItemsRegistry.register("pierce_arrow", () -> new FormSpellArrow(AugmentPierce.INSTANCE, 2));
        WILDEN_HORN = ItemsRegistry.register("wilden_horn", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_horn")));
        WILDEN_SPIKE = ItemsRegistry.register("wilden_spike", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_spike")));
        WILDEN_WING = ItemsRegistry.register("wilden_wing", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_wing")));
        POTION_FLASK = ItemsRegistry.register("potion_flask", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return effectInstance;
                }
            };
            flask.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask"));
            return flask;
        });
        POTION_FLASK_AMPLIFY = ItemsRegistry.register("potion_flask_amplify", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() / 2, Math.min((Integer)Config.ENCHANTED_FLASK_CAP.get(), effectInstance.m_19564_() + 1));
                }
            };
            flask.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask_amplify"));
            return flask;
        });
        POTION_FLASK_EXTEND_TIME = ItemsRegistry.register("potion_flask_extend_time", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() + effectInstance.m_19557_() / 2, effectInstance.m_19564_());
                }
            };
            flask.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask_extend_time"));
            return flask;
        });
        EXPERIENCE_GEM = ItemsRegistry.register("experience_gem", () -> {
            ExperienceGem gem = new ExperienceGem(){

                @Override
                public int getValue() {
                    return 3;
                }
            };
            gem.withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.exp_gem"));
            return gem;
        });
        GREATER_EXPERIENCE_GEM = ItemsRegistry.register("greater_experience_gem", () -> {
            ExperienceGem gem = new ExperienceGem(){

                @Override
                public int getValue() {
                    return 12;
                }
            };
            gem.withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.exp_gem"));
            return gem;
        });
        ENCHANTERS_SWORD = ItemsRegistry.register("enchanters_sword", () -> new EnchantersSword((Tier)Tiers.NETHERITE, 3, -2.4f));
        ENCHANTERS_SHIELD = ItemsRegistry.register("enchanters_shield", EnchantersShield::new);
        CASTER_TOME = ItemsRegistry.register("caster_tome", CasterTome::new);
        DRYGMY_CHARM = ItemsRegistry.register("drygmy_charm", DrygmyCharm::new);
        DRYGMY_SHARD = ItemsRegistry.register("drygmy_shard", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.drygmy_shard")));
        WILDEN_TRIBUTE = ItemsRegistry.register("wilden_tribute", () -> new ModItem(ItemsRegistry.defaultItemProperties().m_41486_()).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.wilden_tribute").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE))).withRarity(Rarity.EPIC));
        SUMMONING_FOCUS = ItemsRegistry.register("summon_focus", SummoningFocus::new);
        SHAPERS_FOCUS = ItemsRegistry.register("shapers_focus", () -> new ShapersFocus(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        SOURCE_BERRY_PIE = ItemsRegistry.register("source_berry_pie", () -> new ModItem(ItemsRegistry.defaultItemProperties().m_41489_(SOURCE_PIE_FOOD)).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.source_food")));
        SOURCE_BERRY_ROLL = ItemsRegistry.register("source_berry_roll", () -> new ModItem(ItemsRegistry.defaultItemProperties().m_41489_(SOURCE_ROLL_FOOD)).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.source_food")));
        ENCHANTERS_MIRROR = ItemsRegistry.register("enchanters_mirror", () -> new EnchantersMirror(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        SORCERER_BOOTS = ItemsRegistry.register("sorcerer_boots", () -> AnimatedMagicArmor.light(ArmorItem.Type.BOOTS));
        SORCERER_LEGGINGS = ItemsRegistry.register("sorcerer_leggings", () -> AnimatedMagicArmor.light(ArmorItem.Type.LEGGINGS));
        SORCERER_ROBES = ItemsRegistry.register("sorcerer_robes", () -> AnimatedMagicArmor.light(ArmorItem.Type.CHESTPLATE));
        SORCERER_HOOD = ItemsRegistry.register("sorcerer_hood", () -> AnimatedMagicArmor.light(ArmorItem.Type.HELMET));
        ARCANIST_BOOTS = ItemsRegistry.register("arcanist_boots", () -> AnimatedMagicArmor.medium(ArmorItem.Type.BOOTS));
        ARCANIST_LEGGINGS = ItemsRegistry.register("arcanist_leggings", () -> AnimatedMagicArmor.medium(ArmorItem.Type.LEGGINGS));
        ARCANIST_ROBES = ItemsRegistry.register("arcanist_robes", () -> AnimatedMagicArmor.medium(ArmorItem.Type.CHESTPLATE));
        ARCANIST_HOOD = ItemsRegistry.register("arcanist_hood", () -> AnimatedMagicArmor.medium(ArmorItem.Type.HELMET));
        BATTLEMAGE_BOOTS = ItemsRegistry.register("battlemage_boots", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.BOOTS));
        BATTLEMAGE_LEGGINGS = ItemsRegistry.register("battlemage_leggings", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.LEGGINGS));
        BATTLEMAGE_ROBES = ItemsRegistry.register("battlemage_robes", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.CHESTPLATE));
        BATTLEMAGE_HOOD = ItemsRegistry.register("battlemage_hood", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.HELMET));
        DOWSING_ROD = ItemsRegistry.register("dowsing_rod", DowsingRod::new);
        ABJURATION_ESSENCE = ItemsRegistry.register("abjuration_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
        CONJURATION_ESSENCE = ItemsRegistry.register("conjuration_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
        AIR_ESSENCE = ItemsRegistry.register("air_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
        EARTH_ESSENCE = ItemsRegistry.register("earth_essence", EarthEssence::new);
        FIRE_ESSENCE = ItemsRegistry.register("fire_essence", FireEssence::new);
        MANIPULATION_ESSENCE = ItemsRegistry.register("manipulation_essence", ManipulationEssence::new);
        WATER_ESSENCE = ItemsRegistry.register("water_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
        AMETHYST_GOLEM_CHARM = ItemsRegistry.register("amethyst_golem_charm", AmethystGolemCharm::new);
        ANNOTATED_CODEX = ItemsRegistry.register("annotated_codex", AnnotatedCodex::new);
        SCRYER_SCROLL = ItemsRegistry.register("scryer_scroll", ScryerScroll::new);
        WIXIE_HAT = ItemsRegistry.register("wixie_hat", () -> new WixieHat().withTooltip("tooltip.ars_nouveau.wixie_hat"));
        ALCHEMISTS_CROWN = ItemsRegistry.register("alchemists_crown", () -> new AlchemistsCrown(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        SPLASH_LAUNCHER = ItemsRegistry.register("splash_flask_cannon", () -> new FlaskCannon.SplashLauncher(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        LINGERING_LAUNCHER = ItemsRegistry.register("lingering_flask_cannon", () -> new FlaskCannon.LingeringLauncher(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        FIREL_DISC = ItemsRegistry.register("music_disc_aria_biblio", () -> new RecordItem(9, () -> (SoundEvent)SoundRegistry.ARIA_BIBLIO.get(), ItemsRegistry.defaultItemProperties().m_41487_(1).m_41497_(Rarity.RARE), 4800));
        SOUND_OF_GLASS = ItemsRegistry.register("music_disc_thistle_the_sound_of_glass", () -> new RecordItem(9, () -> (SoundEvent)SoundRegistry.SOUND_OF_GLASS.get(), ItemsRegistry.defaultItemProperties().m_41487_(1).m_41497_(Rarity.RARE), 3640));
        WILD_HUNT = ItemsRegistry.register("music_disc_firel_the_wild_hunt", () -> new RecordItem(9, () -> (SoundEvent)SoundRegistry.WILD_HUNT.get(), ItemsRegistry.defaultItemProperties().m_41487_(1).m_41497_(Rarity.RARE), 2420));
        STARBY_GIFY = ItemsRegistry.register("starby_gift", () -> new Present(ItemsRegistry.defaultItemProperties().m_41497_(Rarity.EPIC)));
        SPELL_CROSSBOW = ItemsRegistry.register("spell_crossbow", () -> new SpellCrossbow(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        STABLE_WARP_SCROLL = ItemsRegistry.register("stable_warp_scroll", () -> new StableWarpScroll(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        SCRY_CASTER = ItemsRegistry.register("enchanters_eye", () -> new ScryCaster(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        JUMP_RING = ItemsRegistry.register("jump_ring", JumpingRing::new);
    }
}

