/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.tesr.mechanicalManaPool;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalManaPool.BlockEntityManaPoolBase;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.moddingx.libx.render.block.RotatedBlockRenderer;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;

public class RenderManaPoolBase
extends RotatedBlockRenderer<BlockEntityManaPoolBase> {
    public static final double INNER_POOL_HEIGHT = 0.28125;
    public static final double POOL_BOTTOM_HEIGHT = 0.071875;
    private static final TextureAtlasSprite MANA_WATER_SPRITE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("botania", "block/mana_water"));

    protected void doRender(@Nonnull BlockEntityManaPoolBase tile, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (LibXClientConfig.RenderingVisualContent.all && LibXClientConfig.RenderingVisualContent.ManaPoolSettings.manaPoolBase) {
            Block block;
            ItemStack catalystStack = tile.getInventory().getStackInSlot(0);
            if (!catalystStack.m_41619_() && catalystStack.m_41720_() instanceof BlockItem && (block = ((BlockItem)catalystStack.m_41720_()).m_40614_()) instanceof PoolOverlayProvider) {
                PoolOverlayProvider catalyst = (PoolOverlayProvider)block;
                ResourceLocation spriteId = catalyst.getIcon(tile.m_58904_(), tile.m_58899_());
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteId);
                poseStack.m_85836_();
                poseStack.m_85837_(0.125, 0.071875, 0.125);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
                float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + partialTick) / 20.0) + 1.0) * 0.3 + 0.2);
                VertexConsumer vertex = buffer.m_6299_(RenderHelper.ICON_OVERLAY);
                RenderHelper.renderIconFullBright((PoseStack)poseStack, (VertexConsumer)vertex, (TextureAtlasSprite)sprite, (float)alpha);
                poseStack.m_85849_();
            }
            if (tile.getCurrentMana() > 0) {
                double amount = (double)tile.getCurrentMana() / (double)tile.getMaxMana();
                poseStack.m_85836_();
                poseStack.m_85837_(0.1875, 0.071875 + amount * 0.28125, 0.1875);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85841_(0.625f, 0.625f, 0.625f);
                VertexConsumer vertex = buffer.m_6299_(RenderHelper.MANA_POOL_WATER);
                RenderHelper.renderIconFullBright((PoseStack)poseStack, (VertexConsumer)vertex, (TextureAtlasSprite)MANA_WATER_SPRITE, (float)1.0f);
                poseStack.m_85849_();
            }
            ItemStack output_1 = tile.getInventory().getStackInSlot(4);
            ItemStack output_2 = tile.getInventory().getStackInSlot(5);
            poseStack.m_85836_();
            poseStack.m_85837_(0.3125, 0.4375, 0.5);
            if (!output_1.m_41619_() || !output_2.m_41619_()) {
                if (!output_1.m_41619_()) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.02, 0.0, 0.2);
                    poseStack.m_85841_(0.4375f, 0.4375f, 0.4375f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)ClientTickHandler.ticksInGame + partialTick));
                    Minecraft.m_91087_().m_91291_().m_269128_(output_1, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
                    poseStack.m_85849_();
                }
                if (!output_2.m_41619_()) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.02, 0.0, -0.2);
                    poseStack.m_85841_(0.4375f, 0.4375f, 0.4375f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)ClientTickHandler.ticksInGame + partialTick));
                    Minecraft.m_91087_().m_91291_().m_269128_(output_2, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85837_(0.375, 0.0, 0.0);
            for (int i = 1; i < 4; ++i) {
                ItemStack input = tile.getInventory().getStackInSlot(i);
                if (input.m_41619_()) continue;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, -0.2 + 0.2 * (double)(i - 1));
                poseStack.m_85841_(0.4375f, 0.4375f, 0.4375f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(ClientTickHandler.ticksInGame % 360)));
                Minecraft.m_91087_().m_91291_().m_269128_(input, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }
}

