/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.entities.manaSpark.EntityBaseManaSpark;
import net.lmor.botanicalextramachinery.entities.manaSpark.EntityCrimsonManaSpark;
import net.lmor.botanicalextramachinery.entities.manaSpark.EntityMalachiteManaSpark;
import net.lmor.botanicalextramachinery.entities.manaSpark.EntitySaffronManaSpark;
import net.lmor.botanicalextramachinery.entities.manaSpark.EntityShadowManaSpark;
import net.lmor.botanicalextramachinery.util.NumberFormatter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="botanicalextramachinery", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    public static final List<Item> tooltipManaAllBlocks = new ArrayList<Item>();
    public static final List<Item> tooltipEnergyAllBlocks = new ArrayList<Item>();
    public static final List<Item> tooltipWaterAllBlocks = new ArrayList<Item>();
    public static final List<Item> tooltipSparks = new ArrayList<Item>();
    public static final Map<Item, String[]> catalystList = new HashMap<Item, String[]>();
    public static final Map<Item, String[]> upgradeGreenhouse = new HashMap<Item, String[]>();

    private static void addItem() {
        tooltipManaAllBlocks.add(ModBlocks.baseManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateManaPool.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateRunicAltar.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.upgradedIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.advancedIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateIndustrialAgglomerationFactory.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateAlfheimMarket.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.baseOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.ultimateOrechid.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.jadedAmaranthus.m_5456_());
        tooltipManaAllBlocks.add(ModBlocks.greenhouse.m_5456_());
        tooltipEnergyAllBlocks.add(ModBlocks.greenhouse.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.baseApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.upgradedApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.advancedApothecary.m_5456_());
        tooltipWaterAllBlocks.add(ModBlocks.ultimateApothecary.m_5456_());
        tooltipSparks.add(ModItems.baseSpark);
        tooltipSparks.add(ModItems.malachiteSpark);
        tooltipSparks.add(ModItems.saffronSpark);
        tooltipSparks.add(ModItems.shadowSpark);
        tooltipSparks.add(ModItems.crimsonSpark);
        catalystList.put(ModItems.catalystManaInfinity, new String[]{"botanicalextramachinery.tooltip.item.mana_infinity"});
        catalystList.put(ModItems.catalystLivingRockInfinity, new String[]{"botanicalextramachinery.tooltip.item.livingrock"});
        catalystList.put(ModItems.catalystWaterInfinity, new String[]{"botanicalextramachinery.tooltip.item.water"});
        catalystList.put(ModItems.catalystSeedInfinity, new String[]{"botanicalextramachinery.tooltip.item.seed"});
        catalystList.put(ModItems.catalystStoneInfinity, new String[]{"botanicalextramachinery.tooltip.item.stone"});
        catalystList.put(ModItems.catalystWoodInfinity, new String[]{"botanicalextramachinery.tooltip.item.wood"});
        catalystList.put(ModItems.catalystSpeed, new String[]{"botanicalextramachinery.tooltip.item.upgrade_speed_1", "botanicalextramachinery.tooltip.item.upgrade_speed_2"});
        catalystList.put(ModItems.catalystPetal, new String[]{"botanicalextramachinery.tooltip.item.catalyst_petal_1", "botanicalextramachinery.tooltip.item.catalyst_petal_3"});
        catalystList.put(ModItems.catalystPetalBlock, new String[]{"botanicalextramachinery.tooltip.item.catalyst_petal_2", "botanicalextramachinery.tooltip.item.catalyst_petal_3"});
        upgradeGreenhouse.put((Item)ModItems.upgradeCostEnergy, new String[]{"botanicalextramachinery.tooltip.item.upgradeCostEnergy"});
        upgradeGreenhouse.put((Item)ModItems.upgradeFlower_4x, new String[]{"botanicalextramachinery.tooltip.item.upgradeFlower_4x"});
        upgradeGreenhouse.put((Item)ModItems.upgradeFlower_16x, new String[]{"botanicalextramachinery.tooltip.item.upgradeFlower_16x"});
        upgradeGreenhouse.put((Item)ModItems.upgradeFlower_32x, new String[]{"botanicalextramachinery.tooltip.item.upgradeFlower_32x"});
        upgradeGreenhouse.put((Item)ModItems.upgradeFlower_64x, new String[]{"botanicalextramachinery.tooltip.item.upgradeFlower_64x"});
        upgradeGreenhouse.put((Item)ModItems.upgradeGenMana, new String[]{"botanicalextramachinery.tooltip.item.upgradeGenMana"});
        upgradeGreenhouse.put((Item)ModItems.upgradeSlotAdd, new String[]{"botanicalextramachinery.tooltip.item.upgradeSlotAdd"});
        upgradeGreenhouse.put((Item)ModItems.upgradeHeatGreenhouse, new String[]{"botanicalextramachinery.tooltip.item.upgradeHeatGreenhouse"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageMana_1, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageMana_1"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageMana_2, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageMana_2"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageMana_3, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageMana_3"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageEnergy_1, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageEnergy_1"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageEnergy_2, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageEnergy_2"});
        upgradeGreenhouse.put((Item)ModItems.upgradeStorageEnergy_3, new String[]{"botanicalextramachinery.tooltip.item.upgradeStorageEnergy_3"});
        upgradeGreenhouse.put((Item)ModItems.upgradeTickGenMana_1, new String[]{"botanicalextramachinery.tooltip.item.upgradeTickGenMana_1"});
        upgradeGreenhouse.put((Item)ModItems.upgradeTickGenMana_2, new String[]{"botanicalextramachinery.tooltip.item.upgradeTickGenMana_2"});
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        if (tooltipManaAllBlocks.size() == 0) {
            TooltipHandler.addItem();
        }
        if (!(stack = event.getItemStack()).m_41619_()) {
            CompoundTag tag = stack.m_41783_();
            if (tooltipManaAllBlocks.contains(stack.m_41720_()) && stack.m_41782_() && tag.m_128469_("BlockEntityTag").m_128441_("mana")) {
                int mana = tag.m_128469_("BlockEntityTag").m_128451_("mana");
                event.getToolTip().add(Component.m_237110_((String)"botanicalextramachinery.tooltip.block.mana", (Object[])new Object[]{NumberFormatter.formatInteger(mana)}));
            }
            if (tooltipWaterAllBlocks.contains(stack.m_41720_()) && stack.m_41782_() && tag.m_128469_("BlockEntityTag").m_128441_("fluid")) {
                int water = tag.m_128469_("BlockEntityTag").m_128469_("fluid").m_128451_("Amount");
                event.getToolTip().add(Component.m_237110_((String)"botanicalextramachinery.tooltip.block.water", (Object[])new Object[]{NumberFormatter.formatIntegerWater(water)}));
            }
            if (tooltipEnergyAllBlocks.contains(stack.m_41720_()) && stack.m_41782_() && tag.m_128469_("BlockEntityTag").m_128441_("energyStorage")) {
                int energy = tag.m_128469_("BlockEntityTag").m_128451_("energyStorage");
                event.getToolTip().add(Component.m_237110_((String)"botanicalextramachinery.tooltip.block.energy", (Object[])new Object[]{NumberFormatter.formatInteger(energy)}));
            }
            if (tooltipSparks.contains(stack.m_41720_().m_5456_())) {
                int transfer = 0;
                if (stack.m_41720_() == ModItems.baseSpark) {
                    transfer = EntityBaseManaSpark.getRate();
                } else if (stack.m_41720_() == ModItems.malachiteSpark) {
                    transfer = EntityMalachiteManaSpark.getRate();
                } else if (stack.m_41720_() == ModItems.saffronSpark) {
                    transfer = EntitySaffronManaSpark.getRate();
                } else if (stack.m_41720_() == ModItems.shadowSpark) {
                    transfer = EntityShadowManaSpark.getRate();
                } else if (stack.m_41720_() == ModItems.crimsonSpark) {
                    transfer = EntityCrimsonManaSpark.getRate();
                }
                if (transfer != 0) {
                    event.getToolTip().add(Component.m_237110_((String)"botanicalextramachinery.tooltip.item.sparkTransfer", (Object[])new Object[]{NumberFormatter.formatInteger(transfer)}));
                }
            }
            if (catalystList.containsKey(stack.m_41720_())) {
                for (String tooltip_add : catalystList.get(stack.m_41720_())) {
                    event.getToolTip().add(Component.m_237115_((String)tooltip_add));
                }
            }
            if (upgradeGreenhouse.containsKey(stack.m_41720_())) {
                for (String tooltip_add : upgradeGreenhouse.get(stack.m_41720_())) {
                    event.getToolTip().add(Component.m_237115_((String)tooltip_add));
                }
            }
        }
    }
}

