/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.gui.AllBars;
import net.lmor.botanicalextramachinery.util.NumberFormatter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class Bars {
    private final Screen parent;
    private List<AllBars> bars = new ArrayList<AllBars>();
    public List<Integer> x = new ArrayList<Integer>();
    public List<Integer> y = new ArrayList<Integer>();
    public int guiLeft;
    public int guiTop;

    public Bars(Screen parent) {
        this.parent = parent;
    }

    public void setDrawCoord(int x_, int y_) {
        this.x.add(x_);
        this.y.add(y_);
    }

    public void setBar(AllBars bar) {
        this.bars.add(bar);
    }

    public void setGuiCoord(int x, int y) {
        this.guiLeft = x;
        this.guiTop = y;
    }

    public boolean isMouseOver(int mouseX, int mouseY, int index) {
        return this.guiLeft + this.x.get(index) - 1 < mouseX && mouseX < this.guiLeft + this.x.get(index) + this.bars.get(index).getWidth() + 1 && this.guiTop + this.y.get(index) - 1 < mouseY && mouseY < this.guiTop + this.y.get(index) + this.bars.get(index).getHeight() + 1;
    }

    public void draw(GuiGraphics guiGraphics, int[] storage, int[] maxStorage, boolean infinityUpgrade) {
        for (int i = 0; i < this.x.size(); ++i) {
            ResourceLocation barRL = this.bars.get(i).getResourceLocation();
            if (infinityUpgrade && (this.bars.get(i) == AllBars.MANA || this.bars.get(i) == AllBars.WATER)) {
                barRL = AllBars.INFINITY_MANA.getResourceLocation();
                int rgb = Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame * 3 % 360) / 360.0f), (float)0.25f, (float)1.0f);
                float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float blue = (float)(rgb & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)barRL);
            float pct = Math.min((float)storage[i] / (float)maxStorage[i], 1.0f);
            int rel = (int)((float)(this.bars.get(i).getHor() ? this.bars.get(i).getWidth() : this.bars.get(i).getHeight()) * pct);
            guiGraphics.m_280163_(barRL, this.guiLeft + this.x.get(i), this.guiTop + this.y.get(i), 0.0f, 0.0f, this.bars.get(i).getHor() ? rel : this.bars.get(i).getWidth(), this.bars.get(i).getHor() ? this.bars.get(i).getHeight() : rel, this.bars.get(i).getWidth(), this.bars.get(i).getHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderHoveredToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY, int storage, int maxStorage, int index) {
        if (this.isMouseOver(mouseX, mouseY, index) && LibXClientConfig.numericalTooltip) {
            MutableComponent text = Component.m_237110_((String)this.bars.get(index).getTranslatableCode(), (Object[])new Object[]{Component.m_237113_((String)NumberFormatter.formatInteger(storage)), Component.m_237113_((String)NumberFormatter.formatInteger(maxStorage))});
            guiGraphics.m_280557_(this.parent.getMinecraft().f_91062_, (Component)text, mouseX, mouseY);
        }
    }
}

