/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;

public class NumberFormatter {
    public static String formatInteger(int number) {
        if (!LibXClientConfig.formattedNumberSuffix) {
            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
            return formatter.format(number).replace(",", ".");
        }
        return NumberFormatter.formatIntegerWithSuffix(number).replace(",", ".");
    }

    private static String formatIntegerWithSuffix(int number) {
        if (number >= 1000000000) {
            return String.format("%.2fB", (double)number / 1.0E9);
        }
        if (number >= 1000000) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.valueOf(number);
    }

    public static String formatDouble(double number) {
        if (!LibXClientConfig.formattedNumberSuffix) {
            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
            return formatter.format(number).replace(",", ".");
        }
        return NumberFormatter.formatDoubleWithSuffix(number).replace(",", ".");
    }

    private static String formatDoubleWithSuffix(double number) {
        if (number >= 1.0E18) {
            return String.format("%.3fQ", number / 1.0E18);
        }
        if (number >= 1.0E12) {
            return String.format("%.3fT", number / 1.0E12);
        }
        if (number >= 1.0E9) {
            return String.format("%.2fB", number / 1.0E9);
        }
        if (number >= 1000000.0) {
            return String.format("%.1fM", number / 1000000.0);
        }
        if (number >= 1000.0) {
            return String.format("%.1fK", number / 1000.0);
        }
        return String.format("%.2f", number);
    }

    public static String formatIntegerWater(int number) {
        if (!LibXClientConfig.formattedNumberSuffix) {
            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
            return formatter.format(number).replace(",", ".") + "mB";
        }
        return NumberFormatter.formatIntegerWithWaterSuffix(number).replace(",", ".");
    }

    private static String formatIntegerWithWaterSuffix(int number) {
        if (number >= 1000000000) {
            return String.format("%dMB", number / 1000000000);
        }
        if (number >= 1000000) {
            return String.format("%dkB", number / 1000000);
        }
        if (number >= 1000) {
            return String.format("%dB", number / 1000);
        }
        return String.valueOf(number) + "mB";
    }
}

