/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix;

import com.edge.curiusfix.Config;
import com.edge.curiusfix.common.IProxy;
import com.edge.curiusfix.common.NetworkHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="curiusfix")
public class Curiusfix {
    public static final String MODID = "curiusfix";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final IProxy PROXY = Curiusfix.createProxy();

    private static IProxy createProxy() {
        if (FMLEnvironment.dist.isClient()) {
            try {
                Class<?> clientProxyClass = Class.forName("com.edge.curiusfix.client.ClientProxy");
                return (IProxy)clientProxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                LOGGER.debug("ClientProxy not found, using empty implementation");
                return Curiusfix.createEmptyProxy();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create client proxy, using empty implementation", (Throwable)e);
                return Curiusfix.createEmptyProxy();
            }
        }
        try {
            Class<?> serverProxyClass = Class.forName("com.edge.curiusfix.server.ServerProxy");
            return (IProxy)serverProxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.debug("ServerProxy not found, using empty implementation");
            return Curiusfix.createEmptyProxy();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create server proxy", (Throwable)e);
            return Curiusfix.createEmptyProxy();
        }
    }

    private static IProxy createEmptyProxy() {
        return new IProxy(){

            @Override
            public void init() {
            }

            @Override
            public void onServerStarting(MinecraftServer server) {
            }
        };
    }

    public Curiusfix() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        PROXY.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> NetworkHandler.register());
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        try {
            if (!FMLEnvironment.dist.isClient() || event.getServer().m_6982_()) {
                PROXY.onServerStarting(event.getServer());
            } else {
                LOGGER.debug("Integrated server detected on client - skipping server-side registration");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Server-side functionality not available: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error during server starting", (Throwable)e);
        }
        LOGGER.info("curiusFix mod loaded - Death inventory saving enabled");
    }
}

