/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.client;

import com.edge.curiusfix.common.NetworkHandler;
import com.edge.curiusfix.common.RequestInventoryInfoPacket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryInfoScreen
extends Screen {
    private final Screen parent;
    private final String filename;
    private Map<String, Object> info;
    private int scrollOffset = 0;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int ITEMS_PER_PAGE = 10;
    private boolean isLoading = true;
    private static InventoryInfoScreen currentInstance;

    protected InventoryInfoScreen(Screen parent, String filename) {
        this(parent, filename, 0);
    }

    protected InventoryInfoScreen(Screen parent, String filename, int scrollOffset) {
        super((Component)Component.m_237113_((String)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435"));
        this.parent = parent;
        this.filename = filename;
        this.info = new HashMap<String, Object>();
        this.scrollOffset = scrollOffset;
        currentInstance = this;
    }

    protected void m_7856_() {
        List items;
        super.m_7856_();
        if (this.isLoading) {
            NetworkHandler.sendToServer(new RequestInventoryInfoPacket(this.filename));
        }
        int buttonWidth = 200;
        int buttonHeight = 20;
        if (this.info != null && !this.info.isEmpty() && this.info.containsKey("items") && !this.isLoading && (items = (List)this.info.get("items")) != null && !items.isEmpty() && items.size() > 10) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b2 \u0412\u0432\u0435\u0440\u0445"), button -> {
                if (this.scrollOffset > 0) {
                    int newOffset = Math.max(0, this.scrollOffset - 10);
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_((Screen)new InventoryInfoScreen(this.parent, this.filename, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 - 220, this.f_96544_ - 50, 100, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25bc \u0412\u043d\u0438\u0437"), button -> {
                List itemsList = (List)this.info.get("items");
                if (itemsList != null && this.scrollOffset + 10 < itemsList.size()) {
                    int newOffset = Math.min(itemsList.size() - 10, this.scrollOffset + 10);
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_((Screen)new InventoryInfoScreen(this.parent, this.filename, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 + 120, this.f_96544_ - 50, 100, buttonHeight).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c4 \u041d\u0430\u0437\u0430\u0434"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, this.f_96544_ - 30, buttonWidth, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 15, 0xFFFFFF);
        if (this.isLoading) {
            String text = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        } else if (this.info == null || this.info.isEmpty()) {
            String text = "\u0424\u0430\u0439\u043b \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + this.filename;
            int maxWidth = this.f_96543_ - 40;
            if (this.f_96547_.m_92895_(text) > maxWidth) {
                text = this.f_96547_.m_92834_(text, maxWidth - 10) + "...";
            }
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xFF5555);
        } else {
            int y = 50;
            int lineHeight = 12;
            int maxTextWidth = this.f_96543_ - 200;
            String fileText = "\u0424\u0430\u0439\u043b: " + this.filename;
            if (this.f_96547_.m_92895_(fileText) > maxTextWidth) {
                fileText = "\u0424\u0430\u0439\u043b: " + this.f_96547_.m_92834_(this.filename, maxTextWidth - this.f_96547_.m_92895_("\u0424\u0430\u0439\u043b: ") - 10) + "...";
            }
            guiGraphics.m_280488_(this.f_96547_, fileText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
            y += lineHeight + 5;
            if (this.info.containsKey("playerName")) {
                String playerText = "\u0418\u0433\u0440\u043e\u043a: " + String.valueOf(this.info.get("playerName"));
                if (this.f_96547_.m_92895_(playerText) > maxTextWidth) {
                    playerText = "\u0418\u0433\u0440\u043e\u043a: " + this.f_96547_.m_92834_(this.info.get("playerName").toString(), maxTextWidth - this.f_96547_.m_92895_("\u0418\u0433\u0440\u043e\u043a: ") - 10) + "...";
                }
                guiGraphics.m_280488_(this.f_96547_, playerText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight;
            }
            if (this.info.containsKey("saveType")) {
                String saveType = this.info.get("saveType").toString();
                String typeText = "death".equals(saveType) ? "\u041f\u0440\u0438 \u0441\u043c\u0435\u0440\u0442\u0438" : ("dimension_change".equals(saveType) ? "\u041f\u0440\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0435 \u043c\u0435\u0436\u0434\u0443 \u043c\u0438\u0440\u0430\u043c\u0438" : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e");
                guiGraphics.m_280488_(this.f_96547_, "\u0422\u0438\u043f: " + typeText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight;
            }
            if (this.info.containsKey("timestamp")) {
                String timestampText = "\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u043c\u0435\u0442\u043a\u0430: " + String.valueOf(this.info.get("timestamp"));
                if (this.f_96547_.m_92895_(timestampText) > maxTextWidth) {
                    timestampText = this.f_96547_.m_92834_(timestampText, maxTextWidth - 10) + "...";
                }
                guiGraphics.m_280488_(this.f_96547_, timestampText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight;
            }
            if (this.info.containsKey("deathTime")) {
                Date deathTime = (Date)this.info.get("deathTime");
                String deathTimeText = "\u0412\u0440\u0435\u043c\u044f \u0441\u043c\u0435\u0440\u0442\u0438: " + DATE_FORMAT.format(deathTime);
                guiGraphics.m_280488_(this.f_96547_, deathTimeText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight;
            } else if (this.info.containsKey("saveTime")) {
                Date saveTime = (Date)this.info.get("saveTime");
                String saveTimeText = "\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f: " + DATE_FORMAT.format(saveTime);
                guiGraphics.m_280488_(this.f_96547_, saveTimeText, this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight;
            }
            if (this.info.containsKey("experience")) {
                guiGraphics.m_280488_(this.f_96547_, "\u041e\u043f\u044b\u0442: " + String.valueOf(this.info.get("experience")), this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                y += lineHeight + 5;
            }
            if (this.info.containsKey("items")) {
                List items = (List)this.info.get("items");
                if (items != null && !items.isEmpty()) {
                    int minYFromBottom = 50;
                    int maxY = this.f_96544_ - minYFromBottom;
                    guiGraphics.m_280488_(this.f_96547_, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b (" + items.size() + "):", this.f_96543_ / 2 - 100, y, 0xFFFFFF);
                    y += lineHeight + 2;
                    int startIndex = this.scrollOffset;
                    int endIndex = Math.min(startIndex + 10, items.size());
                    int maxWidth = Math.min(400, this.f_96543_ - 200);
                    for (int i = startIndex; i < endIndex && y + lineHeight <= maxY; ++i) {
                        String item = (String)items.get(i);
                        Object displayItem = item;
                        if (this.f_96547_.m_92895_(item) > maxWidth) {
                            displayItem = this.f_96547_.m_92834_(item, maxWidth - 10) + "...";
                        }
                        guiGraphics.m_280488_(this.f_96547_, "  \u2022 " + (String)displayItem, this.f_96543_ / 2 - 100, y, 0xAAAAAA);
                        y += lineHeight;
                    }
                    if (items.size() > 10 && y + lineHeight + 5 < maxY) {
                        String text = String.format("\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u043e %d-%d \u0438\u0437 %d \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432", startIndex + 1, endIndex, items.size());
                        guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - 100, y + 5, 0x888888);
                    }
                } else {
                    guiGraphics.m_280488_(this.f_96547_, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b: (\u043f\u0443\u0441\u0442\u043e)", this.f_96543_ / 2 - 100, y, 0xAAAAAA);
                }
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public static void updateInfo(String filename, Map<String, Object> info) {
        if (currentInstance != null && InventoryInfoScreen.currentInstance.filename.equals(filename)) {
            InventoryInfoScreen.currentInstance.info = info;
            InventoryInfoScreen.currentInstance.isLoading = false;
            if (InventoryInfoScreen.currentInstance.f_96541_ != null) {
                currentInstance.m_7856_();
            }
        }
    }
}

