/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.client;

import com.edge.curiusfix.client.InventoryInfoScreen;
import com.edge.curiusfix.common.NetworkHandler;
import com.edge.curiusfix.common.RequestInventoriesListPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInventoryGui
extends Screen {
    private final Screen parent;
    private final Player player;
    private final String selectedPlayerName;
    private final String filterType;
    private List<String> inventoryFiles;
    private final int scrollOffset;
    private static final int ITEMS_PER_PAGE = 10;
    private boolean isLoading = true;
    private static PlayerInventoryGui currentInstance;

    protected PlayerInventoryGui(Player player, String selectedPlayerName, Screen parent) {
        this(player, selectedPlayerName, parent, null, 0);
    }

    protected PlayerInventoryGui(Player player, String selectedPlayerName, Screen parent, int scrollOffset) {
        this(player, selectedPlayerName, parent, null, scrollOffset);
    }

    protected PlayerInventoryGui(Player player, String selectedPlayerName, Screen parent, String filterType, int scrollOffset) {
        super((Component)Component.m_237113_((String)PlayerInventoryGui.getTitle(selectedPlayerName, filterType)));
        this.player = player;
        this.selectedPlayerName = selectedPlayerName;
        this.parent = parent;
        this.filterType = filterType;
        this.scrollOffset = scrollOffset;
        this.inventoryFiles = new ArrayList<String>();
        currentInstance = this;
    }

    private static String getTitle(String playerName, String filterType) {
        if (filterType == null) {
            return "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0438: " + playerName;
        }
        if ("death".equals(filterType)) {
            return "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0438 \u043f\u0440\u0438 \u0441\u043c\u0435\u0440\u0442\u0438: " + playerName;
        }
        if ("dimension_change".equals(filterType)) {
            return "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0438 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0435: " + playerName;
        }
        return "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0438: " + playerName;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.isLoading && this.player != null) {
            NetworkHandler.sendToServer(new RequestInventoriesListPacket(this.selectedPlayerName, this.filterType));
        }
        int buttonWidth = 200;
        int buttonHeight = 20;
        int startY = 60;
        int spacing = 22;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c4 \u041d\u0430\u0437\u0430\u0434"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY - 30, 100, buttonHeight).m_253136_());
        if (this.inventoryFiles != null && !this.inventoryFiles.isEmpty() && !this.isLoading) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c4 \u041f\u0440\u0435\u0434."), button -> {
                if (this.scrollOffset > 0) {
                    int newOffset = Math.max(0, this.scrollOffset - 10);
                    if (this.f_96541_ != null && this.player != null) {
                        this.f_96541_.m_91152_((Screen)new PlayerInventoryGui(this.player, this.selectedPlayerName, this.parent, this.filterType, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2 + 110, startY - 30, 100, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0421\u043b\u0435\u0434. \u25ba"), button -> {
                if (this.scrollOffset + 10 < this.inventoryFiles.size()) {
                    int newOffset = Math.min(this.inventoryFiles.size() - 10, this.scrollOffset + 10);
                    if (this.f_96541_ != null && this.player != null) {
                        this.f_96541_.m_91152_((Screen)new PlayerInventoryGui(this.player, this.selectedPlayerName, this.parent, this.filterType, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2 + 220, startY - 30, 100, buttonHeight).m_253136_());
            for (int i = 0; i < 10 && this.scrollOffset + i < this.inventoryFiles.size(); ++i) {
                String filename;
                int index = this.scrollOffset + i;
                String buttonText = filename = this.inventoryFiles.get(index);
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)buttonText), button -> this.restoreInventory(filename)).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY + i * spacing, buttonWidth, buttonHeight).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0418\u043d\u0444\u043e"), button -> this.showInventoryInfo(filename)).m_252987_(this.f_96543_ / 2 + buttonWidth / 2 + 5, startY + i * spacing, 50, buttonHeight).m_253136_());
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"), button -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 15, 0xFFFFFF);
        if (this.isLoading) {
            String text = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        } else if ((this.inventoryFiles == null || this.inventoryFiles.isEmpty()) && !this.isLoading) {
            String text = "\u041d\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0445 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435\u0439 \u0434\u043b\u044f " + this.selectedPlayerName;
            int maxWidth = this.f_96543_ - 40;
            if (this.f_96547_.m_92895_(text) > maxWidth) {
                text = this.f_96547_.m_92834_(text, maxWidth - 10) + "...";
            }
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static void updateInventoriesList(String playerName, String filterType, List<String> files) {
        if (currentInstance != null && PlayerInventoryGui.currentInstance.selectedPlayerName.equals(playerName) && (PlayerInventoryGui.currentInstance.filterType == null && filterType == null || PlayerInventoryGui.currentInstance.filterType != null && PlayerInventoryGui.currentInstance.filterType.equals(filterType))) {
            PlayerInventoryGui.currentInstance.inventoryFiles = files;
            PlayerInventoryGui.currentInstance.isLoading = false;
            if (PlayerInventoryGui.currentInstance.f_96541_ != null) {
                currentInstance.m_7856_();
            }
        }
    }

    private void restoreInventory(String filename) {
        Minecraft mc = this.f_96541_;
        if (mc != null && mc.f_91074_ != null && mc.f_91074_.f_108617_ != null) {
            String command = "/deathinventory restore " + filename;
            mc.f_91074_.f_108617_.m_246623_(command);
            mc.m_91152_(null);
        }
    }

    private void showInventoryInfo(String filename) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new InventoryInfoScreen(this, filename));
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

