/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.client;

import com.edge.curiusfix.client.PlayerInventoryGui;
import com.edge.curiusfix.common.NetworkHandler;
import com.edge.curiusfix.common.RequestInventoriesListPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInventoryTypeGui
extends Screen {
    private final Screen parent;
    private final Player player;
    private final String selectedPlayerName;
    private int allCount = -1;
    private int deathCount = -1;
    private int dimensionCount = -1;
    private boolean isLoading = true;
    private static PlayerInventoryTypeGui currentInstance;

    protected PlayerInventoryTypeGui(Player player, String selectedPlayerName, Screen parent) {
        super((Component)Component.m_237113_((String)("\u0422\u0438\u043f \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435\u0439: " + selectedPlayerName)));
        this.player = player;
        this.selectedPlayerName = selectedPlayerName;
        this.parent = parent;
        currentInstance = this;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.isLoading && this.player != null) {
            NetworkHandler.sendToServer(new RequestInventoriesListPacket(this.selectedPlayerName, null));
            NetworkHandler.sendToServer(new RequestInventoriesListPacket(this.selectedPlayerName, "death"));
            NetworkHandler.sendToServer(new RequestInventoriesListPacket(this.selectedPlayerName, "dimension_change"));
        }
        int buttonWidth = 200;
        int buttonHeight = 20;
        int startY = 70;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c4 \u041d\u0430\u0437\u0430\u0434"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY - 35, 100, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("\u0412\u0441\u0435 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0438 (" + this.allCount + ")")), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PlayerInventoryGui(this.player, this.selectedPlayerName, this, null, 0));
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("\u041f\u0440\u0438 \u0441\u043c\u0435\u0440\u0442\u0438 (" + this.deathCount + ")")), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PlayerInventoryGui(this.player, this.selectedPlayerName, this, "death", 0));
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("\u041f\u0440\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0435 \u043c\u0435\u0436\u0434\u0443 \u043c\u0438\u0440\u0430\u043c\u0438 (" + this.dimensionCount + ")")), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PlayerInventoryGui(this.player, this.selectedPlayerName, this, "dimension_change", 0));
            }
        }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"), button -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 15, 0xFFFFFF);
        if (this.isLoading && (this.allCount < 0 || this.deathCount < 0 || this.dimensionCount < 0)) {
            String text = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void updateCounts(String filterType, int count) {
        if (filterType == null) {
            this.allCount = count;
        } else if ("death".equals(filterType)) {
            this.deathCount = count;
        } else if ("dimension_change".equals(filterType)) {
            this.dimensionCount = count;
        }
        if (this.allCount >= 0 && this.deathCount >= 0 && this.dimensionCount >= 0) {
            this.isLoading = false;
            if (this.f_96541_ != null) {
                this.m_7856_();
            }
        }
    }

    public static void updateCountIfOpen(String playerName, String filterType, int count) {
        if (currentInstance != null && PlayerInventoryTypeGui.currentInstance.selectedPlayerName.equals(playerName)) {
            currentInstance.updateCounts(filterType, count);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

