/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.client;

import com.edge.curiusfix.client.PlayerInventoryTypeGui;
import com.edge.curiusfix.common.NetworkHandler;
import com.edge.curiusfix.common.RequestPlayersListPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerListGui
extends Screen {
    private final Player player;
    private List<String> players;
    private Map<String, Integer> playersWithCounts;
    private final int scrollOffset;
    private static final int ITEMS_PER_PAGE = 10;
    private boolean isLoading = true;
    private static PlayerListGui currentInstance;

    protected PlayerListGui(Player player) {
        this(player, 0);
    }

    protected PlayerListGui(Player player, int scrollOffset) {
        super((Component)Component.m_237113_((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u0433\u0440\u043e\u043a\u0430"));
        this.player = player;
        this.scrollOffset = scrollOffset;
        this.players = new ArrayList<String>();
        this.playersWithCounts = new HashMap<String, Integer>();
        currentInstance = this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGuiClient() {
        Minecraft.m_91087_().m_91152_((Screen)new PlayerListGui((Player)Minecraft.m_91087_().f_91074_));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.isLoading && this.player != null) {
            NetworkHandler.sendToServer(new RequestPlayersListPacket());
        }
        int buttonWidth = 200;
        int buttonHeight = 20;
        int startY = 60;
        int spacing = 22;
        if (this.players != null && !this.players.isEmpty() && !this.isLoading) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c4 \u041f\u0440\u0435\u0434."), button -> {
                if (this.scrollOffset > 0) {
                    int newOffset = Math.max(0, this.scrollOffset - 10);
                    if (this.f_96541_ != null && this.player != null) {
                        this.f_96541_.m_91152_((Screen)new PlayerListGui(this.player, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY - 30, 100, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0421\u043b\u0435\u0434. \u25ba"), button -> {
                if (this.scrollOffset + 10 < this.players.size()) {
                    int newOffset = Math.min(this.players.size() - 10, this.scrollOffset + 10);
                    if (this.f_96541_ != null && this.player != null) {
                        this.f_96541_.m_91152_((Screen)new PlayerListGui(this.player, newOffset));
                    }
                }
            }).m_252987_(this.f_96543_ / 2 + buttonWidth / 2 - 100, startY - 30, 100, buttonHeight).m_253136_());
            for (int i = 0; i < 10 && this.scrollOffset + i < this.players.size(); ++i) {
                int index = this.scrollOffset + i;
                String playerName = this.players.get(index);
                int inventoryCount = this.playersWithCounts.getOrDefault(playerName, 0);
                String buttonText = playerName + " (" + inventoryCount + ")";
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)buttonText), button -> {
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_((Screen)new PlayerInventoryTypeGui(this.player, playerName, this));
                    }
                }).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, startY + i * spacing, buttonWidth, buttonHeight).m_253136_());
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"), button -> this.f_96541_.m_91152_(null)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 15, 0xFFFFFF);
        if (this.isLoading) {
            String text = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        } else if ((this.players == null || this.players.isEmpty()) && !this.isLoading) {
            String text = "\u041d\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0445 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435\u0439";
            guiGraphics.m_280488_(this.f_96547_, text, this.f_96543_ / 2 - this.f_96547_.m_92895_(text) / 2, 75, 0xAAAAAA);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static void updatePlayersList(Map<String, Integer> playersWithCounts) {
        if (currentInstance != null) {
            PlayerListGui.currentInstance.playersWithCounts = playersWithCounts;
            PlayerListGui.currentInstance.players = new ArrayList<String>(playersWithCounts.keySet());
            PlayerListGui.currentInstance.players.sort(String::compareTo);
            PlayerListGui.currentInstance.isLoading = false;
            if (PlayerListGui.currentInstance.f_96541_ != null) {
                currentInstance.m_7856_();
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

