/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class ArmorersWorkshopIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ARMORERS_WORKSHOP_MOD_ID = "armourers_workshop";
    private static boolean isArmorersWorkshopLoaded = false;
    private static boolean armorersWorkshopChecked = false;

    public static boolean isArmorersWorkshopLoaded() {
        if (!armorersWorkshopChecked) {
            isArmorersWorkshopLoaded = ModList.get().isLoaded(ARMORERS_WORKSHOP_MOD_ID);
            armorersWorkshopChecked = true;
        }
        return isArmorersWorkshopLoaded;
    }

    public static Map<String, ListTag> saveArmorersWorkshopInventory(ServerPlayer player) {
        Map<String, ListTag> armorersWorkshopData = new HashMap<String, ListTag>();
        if (!ArmorersWorkshopIntegration.isArmorersWorkshopLoaded()) {
            return armorersWorkshopData;
        }
        try {
            armorersWorkshopData = ArmorersWorkshopIntegration.saveViaAPI(player);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Armorers Workshop API classes not found at runtime, skipping integration");
        }
        catch (Exception e) {
            LOGGER.debug("Failed to save Armorers Workshop inventory: {}", (Object)e.getMessage());
        }
        return armorersWorkshopData;
    }

    private static Map<String, ListTag> saveViaAPI(ServerPlayer player) {
        HashMap<String, ListTag> armorersWorkshopData = new HashMap<String, ListTag>();
        try {
            Capability<SkinWardrobe> wardrobeCapability = ArmorersWorkshopIntegration.getWardrobeCapability();
            if (wardrobeCapability == null) {
                LOGGER.debug("Wardrobe capability not available");
                return armorersWorkshopData;
            }
            LazyOptional wardrobeCap = player.getCapability(wardrobeCapability);
            wardrobeCap.ifPresent(cap -> {
                try {
                    String[] slotTypes;
                    CompoundTag nbt = cap.serializeNBT();
                    for (String slotType : slotTypes = new String[]{"HEAD", "CHEST", "LEGS", "FEET", "WEAPON", "WINGS", "OUTFIT"}) {
                        CompoundTag itemTag;
                        ItemStack itemStack;
                        CompoundTag slotTag;
                        if (!nbt.m_128425_(slotType, 10) || !(slotTag = nbt.m_128469_(slotType)).m_128425_("Item", 10) || (itemStack = ItemStack.m_41712_((CompoundTag)(itemTag = slotTag.m_128469_("Item")))).m_41619_()) continue;
                        ListTag itemsList = new ListTag();
                        itemsList.add((Object)itemTag);
                        armorersWorkshopData.put(slotType, itemsList);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to serialize SkinWardrobe: {}", (Object)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Failed to save Armorers Workshop via API: {}", (Object)e.getMessage());
        }
        return armorersWorkshopData;
    }

    public static void restoreArmorersWorkshopInventory(ServerPlayer player, CompoundTag armorersWorkshopTag) {
        if (!ArmorersWorkshopIntegration.isArmorersWorkshopLoaded()) {
            return;
        }
        try {
            ArmorersWorkshopIntegration.restoreViaAPI(player, armorersWorkshopTag);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Armorers Workshop API classes not found at runtime, skipping restore");
        }
        catch (Exception e) {
            LOGGER.debug("Failed to restore Armorers Workshop inventory: {}", (Object)e.getMessage());
        }
    }

    private static void restoreViaAPI(ServerPlayer player, CompoundTag armorersWorkshopTag) {
        try {
            Capability<SkinWardrobe> wardrobeCapability = ArmorersWorkshopIntegration.getWardrobeCapability();
            if (wardrobeCapability == null) {
                LOGGER.debug("Wardrobe capability not available");
                return;
            }
            LazyOptional wardrobeCap = player.getCapability(wardrobeCapability);
            wardrobeCap.ifPresent(cap -> {
                try {
                    CompoundTag nbt = new CompoundTag();
                    for (String slotType : armorersWorkshopTag.m_128431_()) {
                        ListTag itemsList;
                        if (!armorersWorkshopTag.m_128425_(slotType, 9) || (itemsList = armorersWorkshopTag.m_128437_(slotType, 10)).isEmpty()) continue;
                        CompoundTag slotTag = new CompoundTag();
                        slotTag.m_128365_("Item", (Tag)itemsList.m_128728_(0));
                        nbt.m_128365_(slotType, (Tag)slotTag);
                    }
                    cap.deserializeNBT(nbt);
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to deserialize SkinWardrobe: {}", (Object)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Failed to restore Armorers Workshop via API: {}", (Object)e.getMessage());
        }
    }

    private static Capability<SkinWardrobe> getWardrobeCapability() {
        LOGGER.debug("Please uncomment and use correct way to get wardrobe capability from API");
        return null;
    }
}

