/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CURIOS_MOD_ID = "curios";
    private static boolean isCuriosLoaded = false;
    private static boolean curiosChecked = false;

    public static boolean isCuriosLoaded() {
        if (!curiosChecked) {
            isCuriosLoaded = ModList.get().isLoaded(CURIOS_MOD_ID);
            curiosChecked = true;
        }
        return isCuriosLoaded;
    }

    public static Map<String, ListTag> saveCuriosInventory(ServerPlayer player) {
        HashMap<String, ListTag> curiosInventories = new HashMap<String, ListTag>();
        if (!CuriosIntegration.isCuriosLoaded()) {
            return curiosInventories;
        }
        try {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> {
                Map curiosMap = curiosInventory.getCurios();
                for (Map.Entry entry : curiosMap.entrySet()) {
                    String slotType = (String)entry.getKey();
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    ListTag itemsList = new ListTag();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.m_128405_("Slot", i);
                        stack.m_41739_(itemTag);
                        itemsList.add((Object)itemTag);
                    }
                    if (itemsList.isEmpty()) continue;
                    curiosInventories.put(slotType, itemsList);
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Failed to save Curios inventory: {}", (Object)e.getMessage());
        }
        return curiosInventories;
    }

    public static void restoreCuriosInventory(ServerPlayer player, CompoundTag curiosTag) {
        if (!CuriosIntegration.isCuriosLoaded()) {
            return;
        }
        try {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> {
                Map curiosMap = curiosInventory.getCurios();
                for (String slotType : curiosTag.m_128431_()) {
                    int i;
                    if (!curiosTag.m_128425_(slotType, 9)) continue;
                    ListTag itemsList = curiosTag.m_128437_(slotType, 10);
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curiosMap.get(slotType);
                    if (stacksHandler == null) continue;
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    int slots = stackHandler.getSlots();
                    for (i = 0; i < slots; ++i) {
                        stackHandler.setStackInSlot(i, ItemStack.f_41583_);
                    }
                    for (i = 0; i < itemsList.size(); ++i) {
                        CompoundTag itemTag = itemsList.m_128728_(i);
                        int slot = itemTag.m_128451_("Slot");
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                        if (slot < 0 || slot >= slots) continue;
                        stackHandler.setStackInSlot(slot, stack);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Failed to restore Curios inventory: {}", (Object)e.getMessage());
        }
    }
}

