/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class InventoriesListPacket {
    private final String playerName;
    private final String filterType;
    private final List<String> inventoryFiles;

    public InventoriesListPacket(String playerName, String filterType, List<String> inventoryFiles) {
        this.playerName = playerName;
        this.filterType = filterType;
        this.inventoryFiles = inventoryFiles;
    }

    public InventoriesListPacket(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.filterType = buffer.readBoolean() ? buffer.m_130277_() : null;
        int size = buffer.readInt();
        this.inventoryFiles = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            this.inventoryFiles.add(buffer.m_130277_());
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        buffer.writeBoolean(this.filterType != null);
        if (this.filterType != null) {
            buffer.m_130070_(this.filterType);
        }
        buffer.writeInt(this.inventoryFiles.size());
        for (String filename : this.inventoryFiles) {
            buffer.m_130070_(filename);
        }
    }

    public static InventoriesListPacket decode(FriendlyByteBuf buffer) {
        return new InventoriesListPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_() != null) {
                try {
                    Class<?> playerInventoryGuiClass = Class.forName("com.edge.curiusfix.client.PlayerInventoryGui");
                    Method updateMethod = playerInventoryGuiClass.getMethod("updateInventoriesList", String.class, String.class, List.class);
                    updateMethod.invoke(null, this.playerName, this.filterType, this.inventoryFiles);
                    Class<?> typeGuiClass = Class.forName("com.edge.curiusfix.client.PlayerInventoryTypeGui");
                    Method updateCountMethod = typeGuiClass.getMethod("updateCountIfOpen", String.class, String.class, Integer.TYPE);
                    updateCountMethod.invoke(null, this.playerName, this.filterType, this.inventoryFiles.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        context.setPacketHandled(true);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public List<String> getInventoryFiles() {
        return this.inventoryFiles;
    }
}

