/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class InventoryInfoPacket {
    private final String filename;
    private final Map<String, Object> info;

    public InventoryInfoPacket(String filename, Map<String, Object> info) {
        this.filename = filename;
        this.info = info;
    }

    public InventoryInfoPacket(FriendlyByteBuf buffer) {
        this.filename = buffer.m_130277_();
        int size = buffer.readInt();
        this.info = new HashMap<String, Object>();
        block6: for (int i = 0; i < size; ++i) {
            String key = buffer.m_130277_();
            byte type = buffer.readByte();
            switch (type) {
                case 0: {
                    this.info.put(key, buffer.m_130277_());
                    continue block6;
                }
                case 1: {
                    this.info.put(key, buffer.readInt());
                    continue block6;
                }
                case 2: {
                    this.info.put(key, new Date(buffer.readLong()));
                    continue block6;
                }
                case 3: {
                    int listSize = buffer.readInt();
                    ArrayList<String> list = new ArrayList<String>();
                    for (int j = 0; j < listSize; ++j) {
                        list.add(buffer.m_130277_());
                    }
                    this.info.put(key, list);
                }
            }
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.filename);
        buffer.writeInt(this.info.size());
        for (Map.Entry<String, Object> entry : this.info.entrySet()) {
            buffer.m_130070_(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                buffer.writeByte(0);
                buffer.m_130070_((String)value);
                continue;
            }
            if (value instanceof Integer) {
                buffer.writeByte(1);
                buffer.writeInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Date) {
                buffer.writeByte(2);
                buffer.writeLong(((Date)value).getTime());
                continue;
            }
            if (!(value instanceof List)) continue;
            buffer.writeByte(3);
            List list = (List)value;
            buffer.writeInt(list.size());
            for (String item : list) {
                buffer.m_130070_(item);
            }
        }
    }

    public static InventoryInfoPacket decode(FriendlyByteBuf buffer) {
        return new InventoryInfoPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_() != null) {
                try {
                    Class<?> inventoryInfoScreenClass = Class.forName("com.edge.curiusfix.client.InventoryInfoScreen");
                    Method updateMethod = inventoryInfoScreenClass.getMethod("updateInfo", String.class, Map.class);
                    updateMethod.invoke(null, this.filename, this.info);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        context.setPacketHandled(true);
    }

    public String getFilename() {
        return this.filename;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }
}

