/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class InventoryReader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOGS_DIR = "logs/curiusfix/";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static CompoundTag loadInventory(String filename) {
        try {
            Path filePath = Paths.get(LOGS_DIR, filename);
            if (!Files.exists(filePath, new LinkOption[0])) {
                LOGGER.error("Inventory file not found: {}", (Object)filename);
                return null;
            }
            return NbtIo.m_128937_((File)filePath.toFile());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load inventory from " + filename, (Throwable)e);
            return null;
        }
    }

    public static List<String> getAllSavedInventories(String playerName) {
        return InventoryReader.getAllSavedInventories(playerName, null);
    }

    public static List<String> getAllSavedInventories(String playerName, String saveType) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            Path logsPath = Paths.get(LOGS_DIR, new String[0]);
            if (!Files.exists(logsPath, new LinkOption[0])) {
                return files;
            }
            Files.list(logsPath).filter(path -> path.toString().endsWith(".nbt")).forEach(path -> {
                try {
                    CompoundTag tag = NbtIo.m_128937_((File)path.toFile());
                    if (tag != null && tag.m_128441_("playerName")) {
                        String savedPlayerName = tag.m_128461_("playerName");
                        if (playerName == null || savedPlayerName.equalsIgnoreCase(playerName)) {
                            if (saveType == null || saveType.isEmpty()) {
                                files.add(path.getFileName().toString());
                            } else {
                                String fileSaveType;
                                String string = fileSaveType = tag.m_128441_("saveType") ? tag.m_128461_("saveType") : "death";
                                if (saveType.equals(fileSaveType)) {
                                    files.add(path.getFileName().toString());
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read inventory file: " + String.valueOf(path), (Throwable)e);
                }
            });
            files.sort(Collections.reverseOrder());
        }
        catch (IOException e) {
            LOGGER.error("Failed to list inventory files", (Throwable)e);
        }
        return files;
    }

    public static Map<String, List<String>> getAllPlayersInventories() {
        HashMap<String, List<String>> playerInventories = new HashMap<String, List<String>>();
        try {
            Path logsPath = Paths.get(LOGS_DIR, new String[0]);
            if (!Files.exists(logsPath, new LinkOption[0])) {
                return playerInventories;
            }
            Files.list(logsPath).filter(path -> path.toString().endsWith(".nbt")).forEach(path -> {
                try {
                    CompoundTag tag = NbtIo.m_128937_((File)path.toFile());
                    if (tag != null && tag.m_128441_("playerName")) {
                        String playerName = tag.m_128461_("playerName");
                        String filename = path.getFileName().toString();
                        playerInventories.computeIfAbsent(playerName, k -> new ArrayList()).add(filename);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read inventory file: " + String.valueOf(path), (Throwable)e);
                }
            });
            playerInventories.values().forEach(files -> files.sort(Collections.reverseOrder()));
        }
        catch (IOException e) {
            LOGGER.error("Failed to list inventory files", (Throwable)e);
        }
        return playerInventories;
    }

    public static List<String> getAllPlayers() {
        ArrayList<String> players = new ArrayList<String>(InventoryReader.getAllPlayersInventories().keySet());
        Collections.sort(players);
        return players;
    }

    public static Map<String, Object> getInventoryInfo(String filename) {
        CompoundTag tag = InventoryReader.loadInventory(filename);
        if (tag == null) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (tag.m_128441_("playerName")) {
            info.put("playerName", tag.m_128461_("playerName"));
        }
        if (tag.m_128441_("timestamp")) {
            info.put("timestamp", tag.m_128461_("timestamp"));
        }
        if (tag.m_128441_("saveType")) {
            info.put("saveType", tag.m_128461_("saveType"));
        }
        if (tag.m_128441_("deathTime")) {
            info.put("deathTime", new Date(tag.m_128454_("deathTime")));
        } else if (tag.m_128441_("saveTime")) {
            info.put("saveTime", new Date(tag.m_128454_("saveTime")));
        }
        if (tag.m_128441_("experience")) {
            info.put("experience", tag.m_128451_("experience"));
        }
        ArrayList<String> items = new ArrayList<String>();
        if (tag.m_128425_("inventory", 9)) {
            ListTag itemsList = tag.m_128437_("inventory", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_()) continue;
                String itemName = stack.m_41611_().getString();
                int count = stack.m_41613_();
                String display = count > 1 ? itemName + " x" + count : itemName;
                items.add(display);
            }
        }
        info.put("items", items);
        return info;
    }
}

