/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PlayersListPacket {
    private final Map<String, Integer> playersWithCounts;

    public PlayersListPacket(Map<String, Integer> playersWithCounts) {
        this.playersWithCounts = playersWithCounts;
    }

    public PlayersListPacket(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        this.playersWithCounts = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            String playerName = buffer.m_130277_();
            int count = buffer.readInt();
            this.playersWithCounts.put(playerName, count);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playersWithCounts.size());
        for (Map.Entry<String, Integer> entry : this.playersWithCounts.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeInt(entry.getValue().intValue());
        }
    }

    public static PlayersListPacket decode(FriendlyByteBuf buffer) {
        return new PlayersListPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_() != null) {
                try {
                    Class<?> playerListGuiClass = Class.forName("com.edge.curiusfix.client.PlayerListGui");
                    Method updateMethod = playerListGuiClass.getMethod("updatePlayersList", Map.class);
                    updateMethod.invoke(null, this.playersWithCounts);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        context.setPacketHandled(true);
    }

    public Map<String, Integer> getPlayersWithCounts() {
        return this.playersWithCounts;
    }
}

