/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.edge.curiusfix.common.InventoriesListPacket;
import com.edge.curiusfix.common.InventoryReader;
import com.edge.curiusfix.common.NetworkHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RequestInventoriesListPacket {
    private final String playerName;
    private final String filterType;

    public RequestInventoriesListPacket(String playerName, String filterType) {
        this.playerName = playerName;
        this.filterType = filterType;
    }

    public RequestInventoriesListPacket(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.filterType = buffer.readBoolean() ? buffer.m_130277_() : null;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        buffer.writeBoolean(this.filterType != null);
        if (this.filterType != null) {
            buffer.m_130070_(this.filterType);
        }
    }

    public static RequestInventoriesListPacket decode(FriendlyByteBuf buffer) {
        return new RequestInventoriesListPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                List<String> inventoryFiles = InventoryReader.getAllSavedInventories(this.playerName, this.filterType);
                NetworkHandler.sendToClient(new InventoriesListPacket(this.playerName, this.filterType, inventoryFiles), player);
            }
        });
        context.setPacketHandled(true);
    }
}

