/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.edge.curiusfix.common.InventoryInfoPacket;
import com.edge.curiusfix.common.InventoryReader;
import com.edge.curiusfix.common.NetworkHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RequestInventoryInfoPacket {
    private final String filename;

    public RequestInventoryInfoPacket(String filename) {
        this.filename = filename;
    }

    public RequestInventoryInfoPacket(FriendlyByteBuf buffer) {
        this.filename = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.filename);
    }

    public static RequestInventoryInfoPacket decode(FriendlyByteBuf buffer) {
        return new RequestInventoryInfoPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                Map<String, Object> info = InventoryReader.getInventoryInfo(this.filename);
                NetworkHandler.sendToClient(new InventoryInfoPacket(this.filename, info), player);
            }
        });
        context.setPacketHandled(true);
    }
}

