/*
 * Decompiled with CFR 0.152.
 */
package com.edge.curiusfix.common;

import com.edge.curiusfix.common.InventoryReader;
import com.edge.curiusfix.common.NetworkHandler;
import com.edge.curiusfix.common.PlayersListPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RequestPlayersListPacket {
    public RequestPlayersListPacket() {
    }

    public RequestPlayersListPacket(FriendlyByteBuf buffer) {
    }

    public void encode(FriendlyByteBuf buffer) {
    }

    public static RequestPlayersListPacket decode(FriendlyByteBuf buffer) {
        return new RequestPlayersListPacket();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                Map<String, List<String>> allInventories = InventoryReader.getAllPlayersInventories();
                HashMap<String, Integer> playersWithCounts = new HashMap<String, Integer>();
                for (Map.Entry<String, List<String>> entry : allInventories.entrySet()) {
                    playersWithCounts.put(entry.getKey(), entry.getValue().size());
                }
                NetworkHandler.sendToClient(new PlayersListPacket(playersWithCounts), player);
            }
        });
        context.setPacketHandled(true);
    }
}

