/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.furnace;

import com.google.common.collect.Lists;
import divinerpg.block_entities.furnace.CoalstoneFurnaceBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class InfiniFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    public final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    int cookingTotalTime;
    int cookingProgress;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int type) {
            return type == 0 ? InfiniFurnaceBlockEntity.this.cookingProgress : InfiniFurnaceBlockEntity.this.cookingTotalTime;
        }

        public void m_8050_(int type, int value) {
            if (type == 0) {
                InfiniFurnaceBlockEntity.this.cookingProgress = value;
            } else {
                InfiniFurnaceBlockEntity.this.cookingTotalTime = value;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public final String containerName;
    public final double speed;
    public boolean isLit = false;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected InfiniFurnaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String containerName, double speed) {
        super(type, pos, state);
        this.containerName = containerName;
        this.speed = speed;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.m_6423_(), 1);
        }
    }

    public boolean m_7155_(int i, ItemStack stack, Direction direction) {
        return this.m_7013_(i, stack);
    }

    public boolean m_7157_(int i, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 1;
    }

    public void m_58395_(Player p_281647_, List<ItemStack> p_282578_) {
        super.m_58395_(p_281647_, p_282578_);
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.items, (int)i, (int)j);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemstack) && ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.cookingTotalTime = InfiniFurnaceBlockEntity.getTotalCookTime(this.f_58857_, this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public static int getTotalCookTime(Level level, InfiniFurnaceBlockEntity tile) {
        return (int)((double)tile.quickCheck.m_213657_((Container)tile, level).map(AbstractCookingRecipe::m_43753_).orElse(200).intValue() / tile.speed);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack itemstack : this.items) {
            contents.m_36491_(itemstack);
        }
    }

    public int[] m_7071_(Direction direction) {
        return direction == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_UP;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)this.containerName);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> recipesToAward = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(recipesToAward);
        for (Recipe<?> recipe : recipesToAward) {
            if (recipe == null) continue;
            player.m_280300_(recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                InfiniFurnaceBlockEntity.createExperience(level, position, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int entry, float amount) {
        int xpAmount = Mth.m_14143_((float)((float)entry * amount));
        float xpFraction = Mth.m_14187_((float)((float)entry * amount));
        if (xpFraction != 0.0f && Math.random() < (double)xpFraction) {
            ++xpAmount;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)xpAmount);
    }

    public boolean m_40135_(Level level, ServerPlayer player, Recipe<?> recipe) {
        List<Recipe<?>> recipesToAward = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(recipesToAward);
        this.recipesUsed.clear();
        return super.m_40135_(level, player, recipe);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfiniFurnaceBlockEntity block) {
        boolean changes = false;
        Recipe recipe = block.quickCheck.m_213657_((Container)block, level).orElse(null);
        int maxStackSize = block.m_6893_();
        if (block.isLit) {
            if (block.canBurn(recipe, maxStackSize)) {
                ++block.cookingProgress;
                if (block.cookingProgress >= block.cookingTotalTime) {
                    block.cookingProgress = 0;
                    block.cookingTotalTime = InfiniFurnaceBlockEntity.getTotalCookTime(level, block);
                    if (block.burn(recipe, maxStackSize)) {
                        block.m_6029_(recipe);
                    }
                }
            } else {
                block.isLit = false;
                changes = true;
            }
        } else if (block.canLight(recipe, maxStackSize)) {
            block.isLit = true;
            changes = true;
        } else if (block.cookingProgress > 0) {
            block.cookingProgress = Mth.m_14045_((int)(block.cookingProgress - 2), (int)0, (int)block.cookingTotalTime);
        }
        if (block instanceof CoalstoneFurnaceBlockEntity && !block.isLit && level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)AbstractFurnaceBlock.f_48683_)).m_122424_())).m_60713_(Blocks.f_50450_)) {
            block.isLit = true;
            changes = true;
        }
        if (changes) {
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(block.isLit));
            level.m_7731_(pos, state, 3);
            InfiniFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean canLight(@Nullable Recipe<?> recipe, int maxStackSize) {
        return !((ItemStack)this.items.get(0)).m_41619_() && this.canBurn(recipe, maxStackSize);
    }

    private boolean canBurn(@Nullable Recipe<?> recipe, int i) {
        if (recipe != null) {
            ItemStack itemstack = recipe.m_5874_((Container)this, this.f_58857_.m_9598_());
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(1);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= i && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(@Nullable Recipe<?> recipe, int maxStackSize) {
        if (this.canBurn(recipe, maxStackSize)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.m_5874_((Container)this, this.f_58857_.m_9598_());
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.m_41619_()) {
                this.items.set(1, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.isLit = tag.m_128471_("isLit");
        this.cookingProgress = tag.m_128451_("CookTime");
        this.cookingTotalTime = tag.m_128451_("CookTimeTotal");
        CompoundTag compoundtag = tag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("isLit", this.isLit);
        tag.m_128405_("CookTime", this.cookingProgress);
        tag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

