/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.config.CommonConfig;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.util.DivineRPGPacketHandler;
import divinerpg.util.packets.PacketArcanaBar;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;

public class Arcana
implements INBTSerializable<CompoundTag> {
    public static float clientMax;
    public static float clientAmount;
    private int tickDelay = 4;
    private float max;
    private float arcana = this.max = (float)((Integer)CommonConfig.maxArcana.get()).intValue();

    public float getAmount(boolean clientSide) {
        return clientSide ? clientAmount : this.arcana;
    }

    public float getMaxArcana(boolean clientSide) {
        return clientSide ? clientMax : this.max;
    }

    public int getRegenDelay() {
        return this.tickDelay;
    }

    private void sendDataToClient(@Nullable LivingEntity entity) {
        if (entity != null && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketArcanaBar(this));
        }
    }

    public void setAmount(@Nullable LivingEntity entity, float amount) {
        float previous = this.arcana;
        float f = amount > this.max ? this.max : (this.arcana = amount < 0.0f ? 0.0f : amount);
        if (previous != this.arcana) {
            this.sendDataToClient(entity);
        }
    }

    public void modifyAmount(@Nullable LivingEntity entity, float amount) {
        Player player;
        if (!(amount == 0.0f || !(amount > 0.0f) && entity != null && entity instanceof Player && (player = (Player)entity).m_7500_())) {
            this.setAmount(entity, this.arcana + amount);
        }
    }

    public void regen(@Nullable LivingEntity entity) {
        if (entity != null && entity.m_9236_().m_46467_() % (long)this.tickDelay == 0L) {
            this.modifyAmount(entity, entity.m_21023_((MobEffect)MobEffectRegistry.KORMA_ARCANA.get()) ? 4.0f : 1.0f);
        }
    }

    public void setMaxArcana(float max) {
        this.max = max < 0.0f ? 0.0f : max;
    }

    public void setRegenDelay(int delay) {
        this.tickDelay = delay < 1 ? 1 : delay;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("arcana", this.arcana);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.arcana = tag.m_128457_("arcana");
    }
}

