/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.capability.Reputation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ReputationProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<Reputation> REPUTATION = CapabilityManager.get((CapabilityToken)new CapabilityToken<Reputation>(){});
    private Reputation reputation = null;
    private final LazyOptional<Reputation> opt = LazyOptional.of(this::getOrCreateReputation);

    @Nonnull
    private Reputation getOrCreateReputation() {
        if (this.reputation == null) {
            this.reputation = new Reputation();
        }
        return this.reputation;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return REPUTATION.orEmpty(cap, this.opt);
    }

    public CompoundTag serializeNBT() {
        return this.getOrCreateReputation().saveTo(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getOrCreateReputation().loadFrom(nbt);
    }
}

