/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityDolossal;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelDolossal
extends AgeableListModel<EntityDolossal> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("dolossal");
    final ModelPart body;
    final ModelPart neck;
    final ModelPart head;
    final ModelPart rightLeg;
    final ModelPart leftLeg;
    final ModelPart leftWing;
    final ModelPart rightWing;
    final ModelPart[] saddleParts;
    final ModelPart[] ridingParts;

    public ModelDolossal(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.body = root.m_171324_("Body");
        this.neck = root.m_171324_("Neck");
        this.head = this.neck.m_171324_("Head");
        this.rightLeg = this.body.m_171324_("RightLeg");
        this.leftLeg = this.body.m_171324_("LeftLeg");
        this.rightWing = this.body.m_171324_("RightWing");
        this.leftWing = this.body.m_171324_("LeftWing");
        this.saddleParts = new ModelPart[]{this.body.m_171324_("saddle"), this.head.m_171324_("left_saddle_mouth"), this.head.m_171324_("right_saddle_mouth"), this.head.m_171324_("head_saddle"), this.head.m_171324_("mouth_saddle_wrap")};
        this.ridingParts = new ModelPart[]{this.neck.m_171324_("left_saddle_line"), this.neck.m_171324_("right_saddle_line")};
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.3028f, -7.0f, -4.0304f, 16.0f, 14.0f, 21.0f, cubedef), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-5.0f));
        Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(-6.0f, -3.0f, -4.0f, 8.0f, 7.0f, 8.0f, cubedef).m_171514_(59, 75).m_171488_(-4.0f, 1.0f, -2.0f, 5.0f, 13.0f, 5.0f, cubedef), PartPose.m_171419_((float)-3.3028f, (float)5.0f, (float)8.9696f));
        Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(32, 61).m_171488_(-2.0f, -3.0f, -4.0f, 8.0f, 7.0f, 8.0f, cubedef).m_171514_(0, 72).m_171488_(-1.0f, 1.0f, -2.0f, 5.0f, 13.0f, 5.0f, cubedef), PartPose.m_171419_((float)4.6972f, (float)5.0f, (float)8.9696f));
        Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(68, 26).m_171488_(-3.0f, -1.0f, 0.5f, 6.0f, 2.0f, 9.0f, cubedef), PartPose.m_171423_((float)0.6972f, (float)-6.0f, (float)16.4696f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(20, 72).m_171488_(-3.0f, -1.5f, -1.0f, 2.0f, 7.0f, 8.0f, cubedef), PartPose.m_171419_((float)-6.3028f, (float)-5.5f, (float)-1.0304f));
        Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(76, 37).m_171488_(1.0f, -1.5f, -1.0f, 2.0f, 7.0f, 8.0f, cubedef), PartPose.m_171423_((float)7.6972f, (float)-5.5f, (float)-1.0304f, (float)0.0f, (float)0.0f, (float)0.0f));
        Body.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(48, 101).m_171488_(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition Neck = partdefinition.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(40, 35).m_171488_(-5.0f, -17.0f, -8.0f, 10.0f, 18.0f, 8.0f, cubedef), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-5.0f));
        Neck.m_171599_("left_saddle_line", CubeListBuilder.m_171558_().m_171514_(54, 103).m_171481_(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        Neck.m_171599_("right_saddle_line", CubeListBuilder.m_171558_().m_171514_(54, 103).m_171481_(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-4.0f, -9.0f, -11.0f, 8.0f, 10.0f, 12.0f, cubedef).m_171514_(0, 0).m_171488_(0.0f, -15.0f, 0.0f, 0.0f, 8.0f, 10.0f, cubedef), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)-3.0f));
        Head.m_171599_("left_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(51, 106).m_171488_(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubedef), PartPose.f_171404_);
        Head.m_171599_("right_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(51, 106).m_171488_(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubedef), PartPose.f_171404_);
        Head.m_171599_("head_saddle", CubeListBuilder.m_171558_().m_171514_(23, 102).m_171488_(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.f_171404_);
        Head.m_171599_("mouth_saddle_wrap", CubeListBuilder.m_171558_().m_171514_(41, 101).m_171488_(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        Head.m_171599_("UpperJaw", CubeListBuilder.m_171558_().m_171514_(0, 97).m_171488_(-2.0f, -3.75f, -13.0f, 4.0f, 10.0f, 2.0f, cubedef).m_171514_(53, 0).m_171488_(-3.0f, -3.75f, -11.0f, 6.0f, 5.0f, 10.0f, cubedef), PartPose.m_171419_((float)0.0f, (float)-5.25f, (float)-10.0f));
        Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(64, 61).m_171488_(-3.0f, -1.0f, -11.0f, 6.0f, 4.0f, 10.0f, cubedef), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityDolossal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean saddled = entity.m_6254_();
        boolean vehicle = entity.m_20160_();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.f_104207_ = saddled;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.f_104207_ = saddled && vehicle;
        }
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.neck.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        this.head.f_104203_ = -this.neck.f_104203_;
        this.rightWing.f_104205_ = Mth.m_14154_((float)(!entity.m_20096_() ? 1.5707964f + Mth.m_14031_((float)(ageInTicks * 0.2f)) * 0.5f : Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.3f * limbSwingAmount));
        this.leftWing.f_104205_ = -this.rightWing.f_104205_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.neck.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neck);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

