/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityPaleArcher;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class ModelPaleArcher
extends HumanoidModel<EntityPaleArcher> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("pale_archer");

    public ModelPaleArcher(ModelPart part) {
        super(part);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 8).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 4.0f, 8.0f, cubeDef).m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0692f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef).m_171514_(0, 16).m_171488_(-4.5f, -12.3f, -2.5f, 9.0f, 12.0f, 5.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        body.m_171599_("trail", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-4.0f, 2.0f, 1.0f, 8.0f, 7.0f, 4.0f, cubeDef), PartPose.m_171423_((float)0.01f, (float)-1.0f, (float)-3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityPaleArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.f_102816_ = this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        if (entity.m_21205_().m_41720_() instanceof BowItem && entity.m_5912_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(EntityPaleArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (!entity.m_5912_()) {
            this.f_102811_.f_104203_ = this.f_102812_.f_104203_ = Mth.m_14116_((float)((float)Math.atan(200.0f * limbSwing))) * limbSwingAmount + 0.1565f;
        }
        this.f_102810_.f_104203_ = 0.1565f;
        this.f_102811_.f_104205_ = 0.2182f;
        this.f_102812_.f_104205_ = -0.2182f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102809_.f_104201_ = 2.0f;
        this.f_102808_.f_104201_ = 2.0f;
        this.f_102810_.f_104201_ = 14.0f;
        ItemStack itemstack = entity.m_21205_();
        if (entity.m_5912_() && (itemstack.m_41619_() || !(itemstack.m_41720_() instanceof BowItem))) {
            float f1 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            float f2 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
            this.f_102811_.f_104204_ = f1 * 0.6f - 0.1f;
            this.f_102812_.f_104204_ = 0.1f - f1 * 0.6f;
            this.f_102812_.f_104203_ = -1.5707964f;
            this.f_102811_.f_104203_ = -1.5707964f;
            this.f_102811_.f_104203_ -= f1 * 1.2f - f2 * 0.4f;
            this.f_102812_.f_104203_ -= f1 * 1.2f - f2 * 0.4f;
            AnimationUtils.m_102082_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (float)ageInTicks);
        }
    }

    public void m_6002_(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.m_102851_(arm);
        modelpart.f_104200_ += f;
        modelpart.m_104299_(stack);
        modelpart.f_104200_ -= f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102810_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102811_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102812_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

