/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityRollum;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ModelRollum
extends EntityModel<EntityRollum> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rollum");
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public ModelRollum(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.Torso = root.m_171324_("Torso");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        Torso.m_171599_("Torso_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -14.0f, -2.8033f, 16.0f, 14.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.1972f, (float)0.48f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(38, 35).m_171488_(-5.0f, -4.0f, -9.0f, 10.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.3696f, (float)-4.6972f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(47, 17).m_171488_(0.0f, -4.0f, -5.0f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.9f, (float)-2.6696f, (float)-0.6972f));
        LeftArm.m_171599_("LeftLowerArm", CubeListBuilder.m_171558_().m_171514_(28, 50).m_171488_(-4.0f, -1.0f, -4.0f, 5.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)4.0f, (float)-1.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-7.0f, -4.0f, -7.0f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.9f, (float)-2.6696f, (float)1.3028f));
        RightArm.m_171599_("RightLowerArm", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-1.0f, -1.0f, -4.0f, 5.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)4.0f, (float)-3.0f));
        Torso.m_171599_("Hip", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-7.0f, 0.0f, -5.0f, 14.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(56, 50).m_171488_(-2.0f, 0.0f, -4.0f, 6.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)14.0f, (float)1.0f));
        partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(-4.0f, 0.0f, -4.0f, 6.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)14.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityRollum entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw / 57.295776f;
        this.Head.f_104203_ = headPitch / 57.295776f;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.RightArm.f_104204_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.setupAttackAnimation(entity, ageInTicks);
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.RightArm;
    }

    private HumanoidArm getAttackArm(EntityRollum p_102857_) {
        return p_102857_.m_5737_();
    }

    protected void setupAttackAnimation(EntityRollum p_102858_, float p_102859_) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.f_102608_;
            this.Torso.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.RightArm.f_104204_ += this.Torso.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.Head.f_104203_ - 0.7f) * 0.75f;
            modelpart.f_104203_ -= f1 * 1.2f + f2;
            modelpart.f_104204_ += this.Torso.f_104204_ * 2.0f;
            modelpart.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

