/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityWolpertinger;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelWolpertinger
extends EntityModel<EntityWolpertinger> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wolpertinger");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart BackRightFoot;
    private final ModelPart BackLeftFoot;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private float jumpRotation;

    public ModelWolpertinger(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.BackRightFoot = root.m_171324_("BackRightFoot");
        this.BackLeftFoot = root.m_171324_("BackLeftFoot");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.RightLeg = root.m_171324_("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(20, 47).m_171488_(-2.5f, -4.0f, -5.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(8, 0).m_171488_(-0.5f, -1.5f, -5.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 21).m_171488_(-3.0f, -4.5f, -5.5f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(104, 35).m_171488_(-8.0f, -10.3333f, -8.8333f, 7.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(104, 19).m_171488_(1.0f, -10.3333f, -8.8333f, 7.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-4.0f));
        Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(44, 47).m_171488_(-0.5f, -1.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-1.5f, (float)-3.0f));
        Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(38, 47).m_171488_(-0.5f, -1.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-1.5f, (float)-3.0f));
        partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(1.0f, -1.6667f, -3.1667f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(29, 0).m_171488_(-4.0f, -1.6667f, -3.1667f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171488_(-3.0f, -4.6667f, -10.1667f, 6.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.5f, -5.1667f, -10.6667f, 7.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 56).m_171488_(-2.0f, -4.0f, 3.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)18.6667f, (float)4.1667f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("BackRightFoot", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-1.5f, -0.5f, -8.5f, 3.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)23.5f, (float)7.5f));
        partdefinition.m_171599_("BackLeftFoot", CubeListBuilder.m_171558_().m_171514_(42, 4).m_171488_(-1.5f, -0.5f, -8.5f, 3.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)23.5f, (float)7.5f));
        partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 0.0f, -1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)-5.0f));
        partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-4.0f, 0.0f, -1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityWolpertinger entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)entity.f_19797_;
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.jumpRotation = Mth.m_14031_((float)(entity.getJumpCompletion(f) * (float)Math.PI));
        this.BackLeftFoot.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.BackRightFoot.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.LeftLeg.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.RightLeg.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void prepareMobModel(EntityWolpertinger entity, float p_103544_, float p_103545_, float age) {
        super.m_6839_((Entity)entity, p_103544_, p_103545_, age);
        this.jumpRotation = Mth.m_14031_((float)(entity.getJumpCompletion(age) * (float)Math.PI));
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackRightFoot.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackLeftFoot.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

