/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityMadivel;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMadivel
extends EntityModel<EntityMadivel> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("madivel");
    public final ModelPart body;
    public final ModelPart edenSpirit;
    public final ModelPart leftSun;
    public final ModelPart rightSun;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public ModelMadivel(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.body = root.m_171324_("body");
        this.edenSpirit = root.m_171324_("eden_spirit");
        this.leftSun = this.edenSpirit.m_171324_("left_sun");
        this.rightSun = this.edenSpirit.m_171324_("right_sun");
        this.rightLeg = this.body.m_171324_("right_leg");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -8.0f, 18.0f, 19.0f, 18.0f, cubeDef).m_171514_(54, 0).m_171488_(-5.5f, -1.0f, -5.0f, 11.0f, 5.0f, 12.0f, cubeDef).m_171514_(0, 37).m_171488_(-9.0f, -27.0f, -6.0f, 18.0f, 7.0f, 14.0f, cubeDef).m_171514_(72, 17).m_171488_(-5.0f, -26.0f, -4.0f, 10.0f, 10.0f, 9.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(137, 0).m_171488_(-5.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, cubeDef), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(88, 36).m_171488_(1.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, cubeDef), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(100, 97).m_171488_(0.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).m_171514_(26, 88).m_171488_(1.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, cubeDef), PartPose.m_171419_((float)9.0f, (float)-16.0f, (float)2.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-8.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).m_171514_(84, 79).m_171488_(-7.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, cubeDef), PartPose.m_171419_((float)-9.0f, (float)-16.0f, (float)2.0f));
        PartDefinition edenSpirit = partdefinition.m_171599_("eden_spirit", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 2.0f, cubeDef).m_171514_(0, 37).m_171488_(-1.5f, -8.0f, -0.25f, 3.0f, 5.0f, 3.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)2.25f));
        edenSpirit.m_171599_("eden_spirit_head", CubeListBuilder.m_171558_().m_171514_(0, 103).m_171488_(-2.5f, -5.25f, -4.0f, 5.0f, 5.0f, 4.0f, cubeDef).m_171514_(24, 58).m_171488_(-4.0f, -7.25f, -2.0f, 8.0f, 8.0f, 0.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-7.75f, (float)0.75f));
        edenSpirit.m_171599_("left_sun", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(7.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, cubeDef).m_171514_(101, 16).m_171488_(9.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)0.0f));
        edenSpirit.m_171599_("right_sun", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-17.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, cubeDef).m_171514_(0, 93).m_171488_(-15.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.edenSpirit.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.edenSpirit.f_104203_ = headPitch * ((float)Math.PI / 180);
        float orbitRadius = 2.0f;
        float orbitSpeed = 0.1f;
        float sun1OrbitAngle = ageInTicks * orbitSpeed;
        float sun1OffsetX = Mth.m_14089_((float)sun1OrbitAngle) * orbitRadius;
        float sun1OffsetZ = Mth.m_14031_((float)sun1OrbitAngle) * orbitRadius;
        this.leftSun.f_104200_ = this.edenSpirit.f_104200_ + sun1OffsetX + 0.5f;
        this.leftSun.f_104202_ = this.edenSpirit.f_104202_ + sun1OffsetZ - 4.0f;
        float rightSunOrbitAngle = ageInTicks * orbitSpeed * 0.8f;
        float rightSunOffsetX = Mth.m_14089_((float)rightSunOrbitAngle) * orbitRadius;
        float rightSunOffsetZ = Mth.m_14031_((float)rightSunOrbitAngle) * orbitRadius;
        this.rightSun.f_104200_ = this.edenSpirit.f_104200_ + rightSunOffsetX + 0.5f;
        this.rightSun.f_104202_ = this.edenSpirit.f_104202_ + rightSunOffsetZ - 4.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        float f = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.body.f_104205_ = f * 0.05f;
        this.rightLeg.f_104203_ = f;
        this.leftLeg.f_104203_ = f1;
    }

    public void prepareMobModel(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.m_6839_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        float healthFraction = entity.m_21223_() / entity.m_21233_();
        if (healthFraction < 0.33333334f) {
            this.leftSun.f_104207_ = false;
            this.rightSun.f_104207_ = false;
        } else if (healthFraction < 0.6666667f) {
            this.leftSun.f_104207_ = false;
            this.rightSun.f_104207_ = true;
        } else {
            this.leftSun.f_104207_ = true;
            this.rightSun.f_104207_ = true;
        }
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.rightArm.f_104203_ = this.leftArm.f_104203_ = -1.5f + 1.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.edenSpirit.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

