/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.mortum.EntitySoulStealer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelSoulStealer
extends EntityModel<EntitySoulStealer> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("soul_stealer");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart RightEar;
    public final ModelPart LeftEar;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelSoulStealer(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.RightEar = this.Head.m_171324_("RightEar");
        this.LeftEar = this.Head.m_171324_("LeftEar");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-11.0f, -18.0f, -4.0f, 22.0f, 18.0f, 11.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-7.0f, -6.0f, -4.0f, 14.0f, 6.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)-4.0f, (float)1.0f));
        RightEar.m_171599_("rightear_r1", CubeListBuilder.m_171558_().m_171514_(68, 41).m_171488_(-10.0f, -10.0f, 0.0f, 10.0f, 12.0f, 0.0f, cubeDef), PartPose.m_171430_((float)-0.1309f, (float)0.5672f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-4.0f, (float)1.0f));
        LeftEar.m_171599_("leftear_r1", CubeListBuilder.m_171558_().m_171514_(60, 29).m_171488_(0.0f, -10.0f, 0.0f, 10.0f, 12.0f, 0.0f, cubeDef), PartPose.m_171430_((float)-0.1309f, (float)-0.5672f, (float)0.0f));
        Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(-5.0f, -1.0f, -3.0f, 5.0f, 16.0f, 6.0f, cubeDef), PartPose.m_171419_((float)-11.0f, (float)-17.0f, (float)0.0f));
        Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(0.0f, -1.0f, -3.0f, 5.0f, 16.0f, 6.0f, cubeDef), PartPose.m_171419_((float)11.0f, (float)-17.0f, (float)0.0f));
        partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef), PartPose.m_171419_((float)-7.0f, (float)14.0f, (float)0.0f));
        partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(36, 35).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef), PartPose.m_171419_((float)7.0f, (float)14.0f, (float)0.0f));
        Body.m_171599_("RightRibs", CubeListBuilder.m_171558_().m_171514_(60, 53).m_171488_(0.0f, -9.0f, -3.0f, 11.0f, 18.0f, 3.0f, cubeDef), PartPose.m_171419_((float)-11.0f, (float)-9.0f, (float)-4.0f));
        Body.m_171599_("LeftRibs", CubeListBuilder.m_171558_().m_171514_(32, 53).m_171488_(-11.0f, -9.0f, -3.0f, 11.0f, 18.0f, 3.0f, cubeDef), PartPose.m_171419_((float)11.0f, (float)-9.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntitySoulStealer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.RightEar.f_104204_ = -0.19634955f - Mth.m_14089_((float)(ageInTicks * 0.1f + limbSwing * 0.6f)) * 0.08f + limbSwingAmount * 0.2f;
        this.LeftEar.f_104204_ = 0.19634955f + Mth.m_14089_((float)(ageInTicks * 0.1f + limbSwing * 0.5f)) * 0.08f + limbSwingAmount * 0.2f;
        this.LeftArm.f_104205_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        float f = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.f_104205_ = f * 0.1f;
        this.RightLeg.f_104203_ = f;
        this.LeftLeg.f_104203_ = f1;
    }

    public void prepareMobModel(EntitySoulStealer entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.m_6839_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.RightArm.f_104203_ = this.LeftArm.f_104203_ = -1.0f + 1.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

