/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityAridWarrior;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelAridWarrior
extends HumanoidModel<EntityAridWarrior> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("arid_warrior");
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart cloak;

    public ModelAridWarrior(ModelPart part) {
        super(part);
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.cloak = this.f_102810_.m_171324_("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.f_171404_);
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(29, 46).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 6.0f, cubeDef), PartPose.m_171419_((float)-4.0f, (float)-7.0f, (float)-1.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(41, 46).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 6.0f, cubeDef), PartPose.m_171419_((float)4.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-5.0f, -10.0f, -3.0f, 10.0f, 10.0f, 6.0f, cubeDef), PartPose.f_171404_);
        body.m_171599_("hip", CubeListBuilder.m_171558_().m_171514_(27, 11).m_171488_(-5.0f, 0.0f, -2.0f, 10.0f, 4.0f, 5.0f, cubeDef), PartPose.f_171404_);
        body.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(31, 31).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 20.0f, 1.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)3.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(12, 32).m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.5f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDef), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        rightLeg.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, cubeDef), PartPose.m_171419_((float)-1.0f, (float)4.99f, (float)1.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(48, 20).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDef), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        leftLeg.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, cubeDef), PartPose.m_171419_((float)1.0f, (float)4.99f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityAridWarrior entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.f_102816_ = this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        if (entity.m_21205_().m_41720_() instanceof BowItem && entity.m_5912_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(EntityAridWarrior entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f = 0.19634955f + Mth.m_14089_((float)(ageInTicks * 0.05f + limbSwing * 0.5f)) * 0.08f + limbSwingAmount * 0.1f + 0.2182f;
        this.rightEar.f_104204_ = -f;
        this.leftEar.f_104204_ = f;
        float cloakMov = Mth.m_14116_((float)((float)Math.atan(200.0f * limbSwing))) * limbSwingAmount;
        this.cloak.f_104203_ = cloakMov + 0.17453294f;
        this.f_102812_.f_104201_ = -1.0f;
        this.f_102811_.f_104201_ = -1.0f;
        this.f_102811_.f_104200_ = -6.0f;
        this.f_102812_.f_104200_ = 6.0f;
        this.f_102814_.f_104201_ = 12.0f;
        this.f_102813_.f_104201_ = 12.0f;
        this.f_102809_.f_104201_ = -1.99f;
        this.f_102808_.f_104201_ = -1.99f;
        this.f_102810_.f_104201_ = 8.0f;
    }

    public void m_6002_(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.m_102851_(arm);
        modelpart.f_104200_ += f;
        modelpart.m_104299_(stack);
        modelpart.f_104200_ -= f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102810_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102813_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102814_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102811_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102812_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

