/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelHellPig<T extends EntityDivineTameable>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("hell_pig");
    private final ModelPart Head;
    private final ModelPart LeftEar;
    private final ModelPart RightEar;
    private final ModelPart BackRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart FrontRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart Body;

    public ModelHellPig(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.LeftEar = this.Head.m_171324_("LeftEar");
        this.RightEar = this.Head.m_171324_("RightEar");
        this.BackRightLeg = root.m_171324_("BackRightLeg");
        this.FrontLeftLeg = root.m_171324_("FrontLeftLeg");
        this.FrontRightLeg = root.m_171324_("FrontRightLeg");
        this.BackLeftLeg = root.m_171324_("BackLeftLeg");
        this.Body = root.m_171324_("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-8.0f, -3.0f, 1.99f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -3.0f, 2.0f, 10.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)9.0f, (float)-9.0f));
        partdefinition.m_171599_("FrontRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)15.0f, (float)-5.0f));
        partdefinition.m_171599_("BackRightLeg", CubeListBuilder.m_171558_().m_171514_(28, 23).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)15.0f, (float)5.0f));
        partdefinition.m_171599_("BackLeftLeg", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)15.0f, (float)5.0f));
        partdefinition.m_171599_("FrontLeftLeg", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)15.0f, (float)-5.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-4.0f, -5.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(12, 37).m_171488_(-2.5f, -1.0f, -7.0f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(-1, 52).m_171488_(0.0f, -10.0f, -7.0f, 0.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.5f, (float)-7.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.9526f, (float)-2.5952f, (float)-3.0f));
        RightEar.m_171599_("RightEar_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.0474f, (float)-0.4048f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.9526f, (float)-2.5952f, (float)-3.0f));
        LeftEar.m_171599_("LeftEar_r1", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0474f, (float)-0.4048f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        float f1 = ageInTicks * 0.1f + limbSwing * 0.5f;
        float f2 = 0.08f + limbSwingAmount * 0.4f;
        this.LeftEar.f_104205_ = -0.2617994f - Mth.m_14089_((float)(f1 * 1.2f)) * f2;
        this.RightEar.f_104205_ = 0.2617994f + Mth.m_14089_((float)f1) * f2;
        this.BackRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.BackLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.FrontRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.FrontLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

