/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityPumpkinSpider;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelPumpkinSpider
extends EntityModel<EntityPumpkinSpider> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("pumpkin_spider");
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart Thorax;
    public final ModelPart RightLeg4;
    public final ModelPart RightLeg3;
    public final ModelPart RightLeg2;
    public final ModelPart RightLeg1;
    public final ModelPart LeftLeg4;
    public final ModelPart LeftLeg3;
    public final ModelPart LeftLeg2;
    public final ModelPart LeftLeg1;

    public ModelPumpkinSpider(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.Thorax = root.m_171324_("Thorax");
        this.RightLeg4 = root.m_171324_("RightLeg4");
        this.RightLeg3 = root.m_171324_("RightLeg3");
        this.RightLeg2 = root.m_171324_("RightLeg2");
        this.RightLeg1 = root.m_171324_("RightLeg1");
        this.LeftLeg4 = root.m_171324_("LeftLeg4");
        this.LeftLeg3 = root.m_171324_("LeftLeg3");
        this.LeftLeg2 = root.m_171324_("LeftLeg2");
        this.LeftLeg1 = root.m_171324_("LeftLeg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(38, 32).m_171488_(-5.0f, -4.0f, -8.0f, 10.0f, 9.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-7.0f));
        partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, -12.0f, -7.0f, 8.0f, 6.0f, 11.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("Thorax", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -11.0f, 2.0f, 16.0f, 16.0f, 16.0f, cubeDef), PartPose.f_171404_);
        PartDefinition RightLeg4 = partdefinition.m_171599_("RightLeg4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)2.0f));
        RightLeg4.m_171599_("rightleg4_r1", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171488_(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition RightLeg3 = partdefinition.m_171599_("RightLeg3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)-1.0f));
        RightLeg3.m_171599_("rightleg3_r1", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171488_(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightLeg2 = partdefinition.m_171599_("RightLeg2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)-3.0f));
        RightLeg2.m_171599_("rightleg2_r1", CubeListBuilder.m_171558_().m_171514_(48, 4).m_171488_(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition RightLeg1 = partdefinition.m_171599_("RightLeg1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)-5.0f));
        RightLeg1.m_171599_("rightleg1_r1", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-15.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg4 = partdefinition.m_171599_("LeftLeg4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)2.0f));
        LeftLeg4.m_171599_("leftleg4_r1", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition LeftLeg3 = partdefinition.m_171599_("LeftLeg3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)-1.0f));
        LeftLeg3.m_171599_("leftleg3_r1", CubeListBuilder.m_171558_().m_171514_(32, 49).m_171488_(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg2 = partdefinition.m_171599_("LeftLeg2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)-3.0f));
        LeftLeg2.m_171599_("leftleg2_r1", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftLeg1 = partdefinition.m_171599_("LeftLeg1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)-5.0f));
        LeftLeg1.m_171599_("leftleg1_r1", CubeListBuilder.m_171558_().m_171514_(32, 53).m_171488_(1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityPumpkinSpider entityIn, float p_102615_, float p_102616_, float p_102617_) {
        this.LeftLeg3.f_104207_ = this.LeftLeg4.f_104207_ = entityIn.getProvoked();
        this.LeftLeg2.f_104207_ = this.LeftLeg4.f_104207_;
        this.LeftLeg1.f_104207_ = this.LeftLeg4.f_104207_;
        this.RightLeg4.f_104207_ = this.LeftLeg4.f_104207_;
        this.RightLeg3.f_104207_ = this.LeftLeg4.f_104207_;
        this.RightLeg2.f_104207_ = this.LeftLeg4.f_104207_;
        this.RightLeg1.f_104207_ = this.LeftLeg4.f_104207_;
        this.Head.f_104207_ = this.LeftLeg4.f_104207_;
        this.Body.f_104207_ = this.LeftLeg4.f_104207_;
    }

    public void setupAnim(EntityPumpkinSpider entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Thorax.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount + 0.2617994f;
        this.Thorax.f_104201_ = 14.0f;
        this.Thorax.f_104202_ = -2.0f;
        if (!entity.getProvoked()) {
            this.Thorax.f_104203_ = 1.5707964f;
            this.Thorax.f_104201_ = 26.0f;
            this.Thorax.f_104202_ = 3.0f;
        }
        float f = 0.5235988f;
        this.RightLeg2.f_104205_ = this.RightLeg1.f_104205_ = -f;
        this.RightLeg3.f_104205_ = this.RightLeg1.f_104205_;
        this.RightLeg4.f_104205_ = this.RightLeg1.f_104205_;
        this.LeftLeg2.f_104205_ = this.LeftLeg1.f_104205_ = f;
        this.LeftLeg3.f_104205_ = this.LeftLeg1.f_104205_;
        this.LeftLeg4.f_104205_ = this.LeftLeg1.f_104205_;
        float f1 = f / 2.0f;
        float f2 = f / 6.0f;
        this.RightLeg4.f_104204_ = this.LeftLeg1.f_104204_ = f1;
        this.LeftLeg4.f_104204_ = this.RightLeg1.f_104204_ = -f1;
        this.RightLeg3.f_104204_ = this.LeftLeg2.f_104204_ = f2;
        this.LeftLeg3.f_104204_ = this.RightLeg2.f_104204_ = -f2;
        float g = 0.8662f;
        float h = 0.2f;
        float f3 = -(Mth.m_14089_((float)(limbSwing * g * 2.0f)) * h) * limbSwingAmount;
        float f4 = -(Mth.m_14089_((float)(limbSwing * g * 2.0f + (float)Math.PI)) * h) * limbSwingAmount;
        float f5 = -(Mth.m_14089_((float)(limbSwing * g * 2.0f + 1.5707964f)) * h) * limbSwingAmount;
        float f6 = -(Mth.m_14089_((float)(limbSwing * g * 2.0f + 4.712389f)) * h) * limbSwingAmount;
        float f7 = Mth.m_14154_((float)(Mth.m_14031_((float)(limbSwing * g)) * h)) * limbSwingAmount;
        float f8 = Mth.m_14154_((float)(Mth.m_14031_((float)(limbSwing * g + (float)Math.PI)) * h)) * limbSwingAmount;
        float f9 = Mth.m_14154_((float)(Mth.m_14031_((float)(limbSwing * g + 1.5707964f)) * h)) * limbSwingAmount;
        float f10 = Mth.m_14154_((float)(Mth.m_14031_((float)(limbSwing * g + 4.712389f)) * h)) * limbSwingAmount;
        this.RightLeg4.f_104204_ += f3;
        this.LeftLeg4.f_104204_ -= f3;
        this.RightLeg3.f_104204_ += f4;
        this.LeftLeg3.f_104204_ -= f4;
        this.RightLeg2.f_104204_ += f5;
        this.LeftLeg2.f_104204_ -= f5;
        this.RightLeg1.f_104204_ += f6;
        this.LeftLeg1.f_104204_ -= f6;
        this.RightLeg4.f_104205_ += f7;
        this.LeftLeg4.f_104205_ -= f7;
        this.RightLeg3.f_104205_ += f8;
        this.LeftLeg3.f_104205_ -= f8;
        this.RightLeg2.f_104205_ += f9;
        this.LeftLeg2.f_104205_ -= f9;
        this.RightLeg1.f_104205_ += f10;
        this.LeftLeg1.f_104205_ -= f10;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Thorax.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

