/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelSnapper<T extends EntityDivineTameable>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("snapper");
    private final ModelPart Head;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart Body;

    public ModelSnapper(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.FrontRightLeg = root.m_171324_("FrontRightLeg");
        this.FrontLeftLeg = root.m_171324_("FrontLeftLeg");
        this.BackLeftLeg = root.m_171324_("BackLeftLeg");
        this.BackRightLeg = root.m_171324_("BackRightLeg");
        this.Body = root.m_171324_("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(43, 43).m_171488_(-4.0f, -2.5f, -6.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-7.0f));
        partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-11.0f, -1.0f, -3.0f, 22.0f, 0.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171488_(-9.0f, -5.0f, -1.0f, 18.0f, 5.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 43).m_171488_(-7.0f, 0.0f, 0.0f, 14.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-5.0f, -1.0f, -0.01f, 10.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-7.0f));
        partdefinition.m_171599_("FrontLeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)-4.0f));
        partdefinition.m_171599_("BackLeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)4.0f));
        partdefinition.m_171599_("FrontRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)-4.0f));
        partdefinition.m_171599_("BackRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21825_()) {
            this.Head.f_104201_ = 21.0f;
            this.Body.f_104201_ = 19.0f;
            this.FrontLeftLeg.f_104201_ = 22.49f;
            this.FrontRightLeg.f_104201_ = 22.49f;
            this.BackLeftLeg.f_104201_ = 22.49f;
            this.BackRightLeg.f_104201_ = 22.49f;
            this.FrontLeftLeg.f_104203_ = 0.0f;
            this.FrontRightLeg.f_104203_ = 0.0f;
            this.BackLeftLeg.f_104203_ = 0.0f;
            this.BackRightLeg.f_104203_ = 0.0f;
            this.BackRightLeg.f_104205_ = 1.5707964f;
            this.BackLeftLeg.f_104205_ = -1.5707964f;
            this.FrontRightLeg.f_104205_ = this.BackRightLeg.f_104205_;
            this.FrontLeftLeg.f_104205_ = this.BackLeftLeg.f_104205_;
        } else {
            this.Head.f_104201_ = 18.0f;
            this.Body.f_104201_ = 16.0f;
            this.FrontLeftLeg.f_104201_ = 20.0f;
            this.FrontRightLeg.f_104201_ = 20.0f;
            this.BackLeftLeg.f_104201_ = 20.0f;
            this.BackRightLeg.f_104201_ = 20.0f;
            this.BackRightLeg.f_104205_ = 0.0f;
            this.BackLeftLeg.f_104205_ = 0.0f;
            this.FrontRightLeg.f_104205_ = this.BackRightLeg.f_104205_;
            this.FrontLeftLeg.f_104205_ = this.BackLeftLeg.f_104205_;
            this.FrontLeftLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.FrontRightLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
            this.BackLeftLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
            this.BackRightLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        }
        this.Head.f_104204_ = netHeadYaw / 114.59155f;
        this.Head.f_104203_ = headPitch / 114.59155f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

