/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.IAttackTimer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.TamableAnimal;

public class ModelStoneGolem<T extends TamableAnimal>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("stone_golem");
    private final ModelPart crystal;
    private final ModelPart rings;
    private final ModelPart head;
    private final ModelPart Body;
    private final ModelPart leftarm;
    private final ModelPart rightarm;

    public ModelStoneGolem(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.crystal = root.m_171324_("crystal");
        this.rings = root.m_171324_("rings");
        this.head = root.m_171324_("head");
        this.Body = root.m_171324_("Body");
        this.leftarm = root.m_171324_("leftarm");
        this.rightarm = root.m_171324_("rightarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("crystal", CubeListBuilder.m_171558_().m_171514_(104, 94).m_171480_().m_171488_(-2.4216f, -2.3006f, -2.4172f, 5.0f, 5.0f, 5.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-1.0f, (float)0.7854f, (float)0.4363f, (float)0.6109f));
        partdefinition.m_171599_("rings", CubeListBuilder.m_171558_().m_171514_(52, 117).m_171480_().m_171488_(1.5f, 4.0f, 2.0f, 7.0f, 0.0f, 7.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(52, 94).m_171480_().m_171488_(-1.5f, -4.0f, -2.0f, 13.0f, 0.0f, 13.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(52, 107).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 10.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)-5.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171480_().m_171488_(-4.5f, -2.0f, -5.0f, 11.0f, 4.0f, 11.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -6.0f, -3.0f, 10.0f, 4.0f, 9.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(90, 16).m_171480_().m_171488_(-4.0f, -11.0f, 2.0f, 10.0f, 3.0f, 4.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 0).m_171480_().m_171488_(-4.0f, -4.0f, -4.0f, 10.0f, 6.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 7).m_171480_().m_171488_(-4.0f, -6.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(86, 7).m_171480_().m_171488_(-1.0f, -6.0f, -4.0f, 4.0f, 2.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 7).m_171480_().m_171488_(5.0f, -6.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(0, 40).m_171480_().m_171488_(-4.0f, -8.0f, -4.0f, 10.0f, 2.0f, 10.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)-22.0f, (float)-1.0f));
        head.m_171599_("crown1_r1", CubeListBuilder.m_171558_().m_171514_(56, 16).m_171480_().m_171488_(-4.0f, -3.9f, -5.7f, 8.0f, 4.0f, 7.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-7.0f, (float)3.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(7.5f, -9.2f, -2.0f, 10.0f, 10.0f, 11.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(0, 18).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 10.0f, 10.0f, 11.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)-13.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        Body.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171480_().m_171488_(-12.0f, -11.0f, -7.0f, 28.0f, 13.0f, 13.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)0.5f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(0, 94).m_171480_().m_171488_(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 14.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(40, 42).m_171480_().m_171488_(-3.0f, 5.0f, -4.0f, 8.0f, 13.0f, 8.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 69).m_171480_().m_171488_(-3.0f, 18.0f, -5.0f, 9.0f, 13.0f, 10.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-3.5f, 30.0f, -5.5f, 10.0f, 3.0f, 11.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(0.5f, 33.0f, -4.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-2.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(0.5f, 33.0f, 3.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(4.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)18.0f, (float)-16.0f, (float)-0.5f));
        partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(0, 94).m_171480_().m_171488_(-6.0f, -6.0f, -7.0f, 12.0f, 12.0f, 14.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(40, 42).m_171480_().m_171488_(-5.0f, 5.0f, -4.0f, 8.0f, 13.0f, 8.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 69).m_171480_().m_171488_(-6.0f, 18.0f, -5.0f, 9.0f, 13.0f, 10.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-6.5f, 30.0f, -5.5f, 10.0f, 3.0f, 11.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-5.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-2.5f, 33.0f, 3.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(1.5f, 33.0f, -1.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(82, 28).m_171480_().m_171488_(-2.5f, 33.0f, -4.5f, 2.0f, 3.0f, 1.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)-18.0f, (float)-16.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.crystal.f_104203_ += (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
        this.crystal.f_104204_ += (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
    }

    public void prepareMobModel(T e, float par2, float par3, float par4) {
        float r = 0.0f;
        float armR = (float)(Math.cos((double)(par2 * 0.6662f) + Math.PI) * (double)par3 * 0.5);
        float armL = (float)(Math.cos(par2 * 0.6662f) * (double)par3 * 0.5);
        if (((IAttackTimer)e).getAttackTimer() > 0) {
            r = this.getSwingAngle((float)((IAttackTimer)e).getAttackTimer() - par4, 10.0f) - 1.0f;
        }
        this.rightarm.f_104203_ = r + armR;
        this.leftarm.f_104203_ = r + armL;
    }

    private float getSwingAngle(float timer, float maxTimer) {
        return (Math.abs(timer - maxTimer / 2.0f) - maxTimer * 0.25f) / (maxTimer * 0.25f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.crystal.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rings.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

