/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityWhale;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelWhale
extends EntityModel<EntityWhale> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("whale");
    private final ModelPart body;
    private final ModelPart flipperL;
    private final ModelPart flipperR;
    private final ModelPart tail;

    public ModelWhale(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.body = root.m_171324_("body");
        this.flipperL = root.m_171324_("flipperL");
        this.flipperR = root.m_171324_("flipperR");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 8.0f, 6.0f, 24.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)18.0f, (float)-9.0f));
        partdefinition.m_171599_("flipperL", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)21.0f, (float)0.0f));
        partdefinition.m_171599_("flipperR", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-6.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)21.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171480_().m_171488_(-6.0f, 0.0f, 6.0f, 12.0f, 2.0f, 4.0f, CubeDeformation.f_171458_).m_171555_(false).m_171514_(0, 42).m_171480_().m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.f_171458_).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)15.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityWhale entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.flipperR.f_104205_ = (float)(-Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.flipperL.f_104205_ = (float)(Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.tail.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount / 4.0);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.flipperL.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.flipperR.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

