/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.client.models.ModelHat;
import divinerpg.util.Utils;
import java.util.UUID;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerHatRender<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelHat<T> modelHat;
    private final ResourceLocation dev = new ResourceLocation("divinerpg", "textures/model/devhats/hat_red.png");
    private final ResourceLocation tester = new ResourceLocation("divinerpg", "textures/model/devhats/hat_blue.png");
    private final ResourceLocation artist = new ResourceLocation("divinerpg", "textures/model/devhats/hat_purple.png");
    private final ResourceLocation special = new ResourceLocation("divinerpg", "textures/model/devhats/hat_yellow.png");
    private final ResourceLocation friend = new ResourceLocation("divinerpg", "textures/model/devhats/hat_pink.png");

    public PlayerHatRender(RenderLayerParent<T, M> parent, EntityModelSet set) {
        super(parent);
        this.modelHat = new ModelHat(set.m_171103_(ModelHat.LAYER_LOCATION));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID id = entity.m_20148_();
        if (((Player)entity).f_36093_.m_36052_(3).m_41619_() && !entity.m_20145_() && entity.m_36170_(PlayerModelPart.HAT) && (Utils.isDeveloperName(id) || Utils.isTesterName(id) || Utils.isFriend(id) || Utils.isSpecial(id) || Utils.isArtist(id))) {
            this.modelHat.hat.m_104315_(((PlayerModel)this.m_117386_()).f_102808_);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
            this.modelHat.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        UUID id = entity.m_20148_();
        if (Utils.isSpecial(id)) {
            return this.special;
        }
        if (Utils.isTesterName(id)) {
            return this.tester;
        }
        if (Utils.isArtist(id)) {
            return this.artist;
        }
        if (Utils.isFriend(id)) {
            return this.friend;
        }
        return this.dev;
    }
}

