/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.bosses.StatueBlockEntity;
import divinerpg.blocks.base.BlockStatueColored;
import divinerpg.client.models.boss.ModelAncientEntity;
import divinerpg.client.models.boss.ModelAyeraco;
import divinerpg.client.models.boss.ModelDensos;
import divinerpg.client.models.boss.ModelDramix;
import divinerpg.client.models.boss.ModelEternalArcher;
import divinerpg.client.models.boss.ModelExperiencedCori;
import divinerpg.client.models.boss.ModelKarot;
import divinerpg.client.models.boss.ModelKingOfScorchers;
import divinerpg.client.models.boss.ModelKitra;
import divinerpg.client.models.boss.ModelParasecta;
import divinerpg.client.models.boss.ModelSoulFiend;
import divinerpg.client.models.boss.ModelSunstorm;
import divinerpg.client.models.boss.ModelTermasect;
import divinerpg.client.models.boss.ModelTwilightDemon;
import divinerpg.client.models.boss.ModelVamacheron;
import divinerpg.client.models.vanilla.ModelWatcher;
import divinerpg.enums.BlockColor;
import divinerpg.registries.BlockRegistry;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderStatue
implements BlockEntityRenderer<StatueBlockEntity> {
    BlockEntityRendererProvider.Context context;
    public static final ResourceLocation ancient_entity = RenderStatue.location("ancient_entity");
    public static final ResourceLocation the_watcher = RenderStatue.location("the_watcher");
    public static final ResourceLocation king_of_scorchers = RenderStatue.location("king_of_scorchers");
    public static final ResourceLocation kitra = RenderStatue.location("kitra");
    public static final ResourceLocation ayeraco_blue = RenderStatue.location("ayeraco_blue");
    public static final ResourceLocation ayeraco_green = RenderStatue.location("ayeraco_green");
    public static final ResourceLocation ayeraco_pink = RenderStatue.location("ayeraco_pink");
    public static final ResourceLocation ayeraco_purple = RenderStatue.location("ayeraco_purple");
    public static final ResourceLocation ayeraco_red = RenderStatue.location("ayeraco_red");
    public static final ResourceLocation ayeraco_yellow = RenderStatue.location("ayeraco_yellow");
    public static final ResourceLocation ayeraco_white = RenderStatue.location("ayeraco_white");
    public static final ResourceLocation parasecta = RenderStatue.location("parasecta");
    public static final ResourceLocation dramix = RenderStatue.location("dramix");
    public static final ResourceLocation sunstorm = RenderStatue.location("sunstorm");
    public static final ResourceLocation termasect = RenderStatue.location("termasect");
    public static final ResourceLocation eternal_archer = RenderStatue.location("eternal_archer");
    public static final ResourceLocation experienced_cori = RenderStatue.location("experienced_cori");
    public static final ResourceLocation karot = RenderStatue.location("karot");
    public static final ResourceLocation densos = RenderStatue.location("densos");
    public static final ResourceLocation reyvor = RenderStatue.location("reyvor");
    public static final ResourceLocation soul_fiend = RenderStatue.location("soul_fiend");
    public static final ResourceLocation twilight_demon = RenderStatue.location("twilight_demon");
    public static final ResourceLocation vamacheron = RenderStatue.location("mortum_cadillion");

    public RenderStatue(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(StatueBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Model model = this.getModel(te);
        matrixStack.m_85836_();
        if (te.m_58900_().m_60713_((Block)BlockRegistry.kitraStatue.get()) || te.m_58900_().m_60713_((Block)BlockRegistry.sunstormStatue.get())) {
            matrixStack.m_85837_(0.5, 0.375, 0.5);
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
        } else if (te.m_58900_().m_60713_((Block)BlockRegistry.karotStatue.get()) || te.m_58900_().m_60713_((Block)BlockRegistry.theWatcherStatue.get()) || te.m_58900_().m_60713_((Block)BlockRegistry.experiencedCoriStatue.get())) {
            matrixStack.m_85837_(0.5, 0.9, 0.5);
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        } else {
            matrixStack.m_85837_(0.5, 0.6, 0.5);
            matrixStack.m_85841_(0.4f, 0.4f, 0.4f);
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)te.m_58900_().m_61143_((Property)AbstractFurnaceBlock.f_48683_)).m_122435_()));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture(te)));
        model.m_7695_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    private Model getModel(StatueBlockEntity tile) {
        Block block = tile.m_58900_().m_60734_();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return new ModelAncientEntity(this.context.m_173582_(ModelAncientEntity.LAYER_LOCATION));
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return new ModelDensos(this.context.m_173582_(ModelDensos.LAYER_LOCATION));
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return new ModelDramix(this.context.m_173582_(ModelDramix.LAYER_LOCATION));
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return new ModelEternalArcher(this.context.m_173582_(ModelEternalArcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return new ModelKarot(this.context.m_173582_(ModelKarot.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return new ModelKingOfScorchers(this.context.m_173582_(ModelKingOfScorchers.LAYER_LOCATION));
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return new ModelParasecta(this.context.m_173582_(ModelParasecta.LAYER_LOCATION));
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return new ModelDensos(this.context.m_173582_(ModelDensos.LAYER_LOCATION));
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return new ModelSoulFiend(this.context.m_173582_(ModelSoulFiend.LAYER_LOCATION));
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return new ModelWatcher(this.context.m_173582_(ModelWatcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return new ModelTwilightDemon(this.context.m_173582_(ModelTwilightDemon.LAYER_LOCATION));
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return new ModelVamacheron(this.context.m_173582_(ModelVamacheron.LAYER_LOCATION));
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return new ModelAyeraco(this.context.m_173582_(ModelAyeraco.LAYER_LOCATION));
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return new ModelTermasect(this.context.m_173582_(ModelTermasect.LAYER_LOCATION));
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return new ModelSunstorm(this.context.m_173582_(ModelSunstorm.LAYER_LOCATION));
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return new ModelExperiencedCori(this.context.m_173582_(ModelExperiencedCori.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return new ModelKitra(this.context.m_173582_(ModelKitra.LAYER_LOCATION));
        }
        return new BookModel(this.context.m_173582_(ModelLayers.f_171271_));
    }

    private static ResourceLocation location(String path) {
        return new ResourceLocation("divinerpg", "textures/entity/" + path + ".png");
    }

    private ResourceLocation texture(StatueBlockEntity tile) {
        Block block = tile.m_58900_().m_60734_();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return ancient_entity;
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return the_watcher;
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return king_of_scorchers;
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return kitra;
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return switch ((BlockColor)((Object)tile.m_58900_().m_61143_(BlockStatueColored.COLOR))) {
                case BlockColor.BLUE -> ayeraco_blue;
                case BlockColor.GREEN -> ayeraco_green;
                case BlockColor.PINK -> ayeraco_pink;
                case BlockColor.PURPLE -> ayeraco_purple;
                case BlockColor.RED -> ayeraco_red;
                case BlockColor.YELLOW -> ayeraco_yellow;
                default -> ayeraco_white;
            };
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return parasecta;
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return dramix;
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return sunstorm;
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return termasect;
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return eternal_archer;
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return experienced_cori;
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return densos;
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return reyvor;
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return karot;
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return soul_fiend;
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return twilight_demon;
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return vamacheron;
        }
        return new ResourceLocation("divinerpg", "textures/block/black_hungerstone.png");
    }
}

