/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei;

import divinerpg.compat.jei.category.ArcaniumExtractorCategory;
import divinerpg.compat.jei.category.InfusionTableCategory;
import divinerpg.recipe.ArcaniumExtractorRecipe;
import divinerpg.recipe.InfusionTableRecipe;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public final class JEICompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("divinerpg", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "coalstone_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "demon_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "greenlight_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "molten_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "moonlight_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "oceanfire_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "whitefire_furnace"))), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "arcanium_extractor"))), new RecipeType[]{ArcaniumExtractorCategory.ARCANIUM_EXTRACTOR_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "infusion_table"))), new RecipeType[]{InfusionTableCategory.INFUSION_TABLE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaniumExtractorCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionTableCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<ArcaniumExtractorRecipe> arcaniumExtractorRecipes = new ArrayList<ArcaniumExtractorRecipe>();
        ArrayList<InfusionTableRecipe> infusionTableRecipes = new ArrayList<InfusionTableRecipe>();
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        for (Recipe i : manager.m_44051_()) {
            if (!(i instanceof ArcaniumExtractorRecipe)) continue;
            ArcaniumExtractorRecipe arcaniumExtractorRecipe = (ArcaniumExtractorRecipe)i;
            arcaniumExtractorRecipes.add(arcaniumExtractorRecipe);
        }
        for (Recipe i : manager.m_44051_()) {
            if (!(i instanceof InfusionTableRecipe)) continue;
            InfusionTableRecipe infusionTableRecipe = (InfusionTableRecipe)i;
            infusionTableRecipes.add(infusionTableRecipe);
        }
        registration.addRecipes(ArcaniumExtractorCategory.ARCANIUM_EXTRACTOR_TYPE, arcaniumExtractorRecipes);
        registration.addRecipes(InfusionTableCategory.INFUSION_TABLE_TYPE, infusionTableRecipes);
    }
}

