/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.MobEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TwilightSky
extends DimensionSpecialEffects {
    public static final ResourceLocation SUN_LOCATION = new ResourceLocation("divinerpg", "textures/particle/twilight_sun.png");
    public static final ResourceLocation POG_SUN_LOCATION = new ResourceLocation("divinerpg", "textures/particle/pog_sun.png");
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer starBuffer;

    public TwilightSky() {
        super(256.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = TwilightSky.drawStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
        tesselator = Tesselator.m_85913_();
        bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        bufferbuilder$renderedbuffer = TwilightSky.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    public Vec3 m_5927_(Vec3 color, float sunHeight) {
        return color.m_82542_((double)sunHeight * 0.94 + 0.06, (double)sunHeight * 0.94 + 0.06, (double)sunHeight * 0.91 + 0.09);
    }

    public boolean m_5781_(int i, int ii) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        setupFog.run();
        if (!isFoggy && (fogtype = camera.m_167685_()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !TwilightSky.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.m_171660_(camera.m_90583_(), partialTick);
            float f = (float)vec3.f_82479_;
            float f1 = (float)vec3.f_82480_;
            float f2 = (float)vec3.f_82481_;
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderinstance = RenderSystem.getShader();
            this.skyBuffer.m_85921_();
            this.skyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] afloat = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
            if (afloat != null) {
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                float f3 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(f3));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)((double)j * (Math.PI * 2) / 16.0);
                    float f8 = Mth.m_14031_((float)f7);
                    float f9 = Mth.m_14089_((float)f7);
                    bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                poseStack.m_85849_();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            float f11 = 1.0f - level.m_46722_(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTick) * 360.0f));
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(level.m_46472_() == LevelRegistry.MORTUM && camera.m_90583_().f_82480_ < 0.0 ? POG_SUN_LOCATION : SUN_LOCATION));
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            float f10 = level.m_104811_(partialTick) * f11 * 1.01f;
            if (f10 > 0.0f) {
                RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                FogRenderer.m_109017_();
                this.starBuffer.m_85921_();
                this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
                VertexBuffer.m_85931_();
                setupFog.run();
            }
            if (level.m_46472_() == LevelRegistry.EDEN) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.9f, (float)1.0f);
            } else if (level.m_46472_() == LevelRegistry.WILDWOOD) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else if (level.m_46472_() == LevelRegistry.APALACHIA) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.8f, (float)1.0f, (float)1.0f);
            } else if (level.m_46472_() == LevelRegistry.SKYTHERN) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else if (level.m_46472_() == LevelRegistry.MORTUM) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.8f, (float)0.8f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_) || livingentity.m_21023_((MobEffect)MobEffectRegistry.HEAVY_AIR.get());
    }

    public static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float g) {
        float f = Math.signum(g) * 512.0f;
        RenderSystem.setShader(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        builder.m_5483_(0.0, (double)g, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            builder.m_5483_((double)f * Math.cos((double)i * (Math.PI / 180)), (double)g, 512.0 * Math.sin((double)i * (Math.PI / 180))).m_5752_();
        }
        return builder.m_231175_();
    }

    public static BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return builder.m_231175_();
    }
}

