/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import divinerpg.entities.vanilla.overworld.EntityAequorea;
import divinerpg.util.DamageSources;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class TurtleEatAequorea
extends Goal {
    Turtle turtle;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public TurtleEatAequorea(Turtle turtle, double speed, boolean followAtAllCosts) {
        this.turtle = turtle;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = followAtAllCosts;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.turtle.m_5448_() instanceof EntityAequorea;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.turtle.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.turtle.m_21573_().m_26571_();
        }
        if (!this.turtle.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.turtle.m_21573_().m_26536_(this.path, this.speedModifier);
        this.turtle.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.turtle.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.turtle.m_6710_((LivingEntity)null);
        }
        this.turtle.m_21561_(false);
        this.turtle.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.turtle.m_5448_();
        this.turtle.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.turtle.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.turtle.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.turtle.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.turtle.m_217043_().m_188503_(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.turtle.m_21573_().m_26570_() != null ? ((finalPathPoint = this.turtle.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.turtle.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity entity, double range) {
        double d0 = this.getAttackReachSqr(entity);
        if (range <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            entity.m_6469_(DamageSources.source(entity.m_9236_(), DamageSources.TURTLE), entity.m_21223_());
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.turtle.m_20205_() * 2.0f * this.turtle.m_20205_() * 2.0f + p_179512_1_.m_20205_();
    }
}

