/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.SoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityWraith
extends EntityDivineTameable {
    public EntityWraith(EntityType<? extends TamableAnimal> type, Level worldIn, Player player) {
        this(type, worldIn);
        this.m_21828_(player);
    }

    public EntityWraith(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn, 1.0f);
        this.f_21342_ = new MoveHelperController(this);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAroundGoal(this));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.15625f;
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.95f;
    }

    @Nullable
    public SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.WRAITH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegistry.WRAITH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.WRAITH_HURT.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityWraith parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityWraith ent) {
            super((Mob)ent);
            this.parentEntity = ent;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_20242_(true);
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.f_19857_ = this.m_24991_(this.f_24974_.f_19857_, f, 90.0f);
                float f1 = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                this.f_24974_.m_7910_(f1);
                double d4 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                this.f_24974_.f_19858_ = this.m_24991_(this.f_24974_.f_19858_, f2, 20.0f);
                this.f_24974_.m_21567_(d1 > 0.0 ? f1 : -f1);
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                    Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                    double d5 = vector3d.m_82553_();
                    if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d5))) {
                        this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                    } else {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityWraith parentEntity;

        public RandomFlyGoal(EntityWraith ent) {
            this.parentEntity = ent;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            if (this.parentEntity.m_5448_() != null) {
                return false;
            }
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.parentEntity.m_217043_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityWraith parentEntity;

        public LookAroundGoal(EntityWraith ent) {
            this.parentEntity = ent;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vector3d = this.parentEntity.m_20184_();
                this.parentEntity.f_19860_ = this.parentEntity.f_19858_ = -((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.m_5448_();
                if (livingentity.m_20280_((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.parentEntity.m_20185_();
                    double d2 = livingentity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.f_19860_ = this.parentEntity.f_19858_ = -((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

