/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.ai.EscapeWaterGoal;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class EntityDivineFlyingMob
extends EntityDivineMonster {
    @Nullable
    protected Vec3 pathfindPos;
    protected final float preferredHeight;
    protected final float preferredDistance;
    protected final float pathFindDistance;

    protected EntityDivineFlyingMob(EntityType<? extends EntityDivineMonster> type, Level worldIn) {
        super(type, worldIn);
        this.preferredHeight = 5.0f;
        this.preferredDistance = 8.0f;
        this.pathFindDistance = 14.0f;
    }

    protected EntityDivineFlyingMob(EntityType<? extends EntityDivineMonster> type, Level worldIn, float pathFindDistance) {
        super(type, worldIn);
        this.preferredHeight = 5.0f;
        this.preferredDistance = 8.0f;
        this.pathFindDistance = pathFindDistance;
    }

    protected EntityDivineFlyingMob(EntityType<? extends EntityDivineMonster> type, Level worldIn, float preferredHeight, float preferredDistance, float pathFindDistance) {
        super(type, worldIn);
        this.preferredHeight = preferredHeight;
        this.preferredDistance = preferredDistance;
        this.pathFindDistance = pathFindDistance;
    }

    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new EscapeWaterGoal((LivingEntity)this));
        if (!(this instanceof RangedAttackMob)) {
            this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        if (this.m_5912_()) {
            this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_142535_(float f, float g, DamageSource d) {
        return false;
    }

    protected void m_7840_(double d, boolean b, BlockState s, BlockPos p) {
    }

    public boolean m_6147_() {
        return false;
    }

    public void reachTarget() {
    }

    protected void m_8024_() {
        boolean blockedPath;
        if (!this.m_20068_()) {
            this.m_20242_(true);
        }
        if (this.m_20069_()) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.5, this.m_20184_().f_82481_);
            this.pathfindPos = null;
            this.m_21573_().m_26573_();
            return;
        }
        boolean bl = blockedPath = this.f_19862_ || this.f_19863_;
        if (!blockedPath) {
            Vec3 futurePos = this.m_20182_().m_82520_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            BlockPos pos = new BlockPos((int)futurePos.f_82479_, (int)futurePos.f_82480_, (int)futurePos.f_82481_);
            BlockState state = this.m_9236_().m_8055_(pos);
            blockedPath = state.m_60713_(Blocks.f_152499_) || state.m_60713_(Blocks.f_49991_) || !state.m_60812_((BlockGetter)this.m_9236_(), pos).equals(Shapes.m_83040_());
        }
        LivingEntity target = this.m_5448_();
        if (this.pathfindPos == null || blockedPath) {
            double findX = this.m_20185_() + (double)((this.f_19796_.m_188501_() - 0.5f) * this.pathFindDistance);
            double findY = this.m_20186_() + (double)((this.f_19796_.m_188501_() - 0.6f) * this.pathFindDistance);
            double findZ = this.m_20189_() + (double)((this.f_19796_.m_188501_() - 0.5f) * this.pathFindDistance);
            if (this.m_21573_().m_26570_() != null && !blockedPath) {
                BlockPos destination = this.m_21573_().m_26570_().m_77406_();
                this.pathfindPos = new Vec3((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
            } else if (target != null && !blockedPath) {
                if (this instanceof RangedAttackMob) {
                    boolean tooclose = this.m_20270_((Entity)target) < this.preferredDistance;
                    this.pathfindPos = new Vec3(findX + (tooclose ? -1.0 : 1.0) * (target.m_20185_() - this.m_20185_()) / 3.0, findY + (target.m_20186_() - this.m_20186_() + (double)this.preferredHeight), findZ + (tooclose ? -1.0 : 1.0) * (target.m_20189_() - this.m_20189_()) / 3.0);
                } else {
                    this.pathfindPos = target.m_20182_().m_82520_(0.0, 0.5, 0.0);
                }
            } else {
                this.pathfindPos = new Vec3(findX, findY, findZ);
            }
        } else if (target != null && !(this instanceof RangedAttackMob) && Math.sqrt(target.m_20238_(this.pathfindPos)) > 2.0) {
            this.pathfindPos = target.m_20182_().m_82520_(0.0, 0.5, 0.0);
        }
        double speed = this.m_21133_(Attributes.f_22280_);
        this.m_20334_(this.m_20184_().f_82479_ + (this.pathfindPos.f_82479_ - this.m_20185_()) / 64.0 * speed, this.m_20184_().f_82480_ + (this.pathfindPos.f_82480_ - this.m_20186_()) / 64.0 * speed, this.m_20184_().f_82481_ + (this.pathfindPos.f_82481_ - this.m_20189_()) / 64.0 * speed);
        double distanceX = this.pathfindPos.f_82479_ - this.m_20185_();
        double distanceY = this.pathfindPos.f_82480_ - this.m_20186_();
        double distanceZ = this.pathfindPos.f_82481_ - this.m_20189_();
        this.f_19857_ = Utils.rotlerp(this.f_19857_, (float)(Mth.m_14136_((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
        this.f_19858_ = Utils.rotlerp(this.f_19858_, (float)(-(Mth.m_14136_((double)distanceY, (double)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ)) * 180.0 / Math.PI)), 20.0f);
        if (Math.sqrt(this.m_20238_(this.pathfindPos)) < 1.0) {
            this.pathfindPos = null;
            if (this.m_21573_().m_26570_() != null && this.m_21573_().m_26570_().m_77407_() < 1.5f) {
                this.reachTarget();
                this.m_21573_().m_26573_();
            }
        }
    }
}

